/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.api.request;

import io.swagger.v3.oas.annotations.Parameter;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.QueryParam;
import java.io.Serializable;
import lombok.Generated;
import org.apache.fineract.portfolio.common.domain.PeriodFrequencyType;
import org.apache.fineract.portfolio.loanaccount.api.request.ReAgePreviewRequest;
import org.apache.fineract.validation.constraints.EnumValue;
import org.apache.fineract.validation.constraints.LocalDate;
import org.apache.fineract.validation.constraints.Locale;

@LocalDate(dateField="startDate", formatField="dateFormat", localeField="locale")
public class ReAgePreviewRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    @QueryParam(value="frequencyNumber")
    @Parameter(description="The frequency number for the re-aging schedule", required=true)
    @NotNull(message="{org.apache.fineract.reage.frequency-number.not-blank}")
    @Min(value=1L, message="{org.apache.fineract.reage.frequency-number.min}")
    private @NotNull(message="{org.apache.fineract.reage.frequency-number.not-blank}") @Min(value=1L, message="{org.apache.fineract.reage.frequency-number.min}") Integer frequencyNumber;
    @QueryParam(value="frequencyType")
    @Parameter(description="The frequency type (DAYS, WEEKS, MONTHS, YEARS)", required=true)
    @NotBlank(message="{org.apache.fineract.reage.frequency-type.not-blank}")
    @EnumValue(enumClass=PeriodFrequencyType.class, message="{org.apache.fineract.frequency-type.invalid}")
    private @NotBlank(message="{org.apache.fineract.reage.frequency-type.not-blank}") String frequencyType;
    @QueryParam(value="startDate")
    @Parameter(description="The start date for the re-aging schedule", required=true)
    @NotBlank(message="{org.apache.fineract.reage.start-date.not-blank}")
    private @NotBlank(message="{org.apache.fineract.reage.start-date.not-blank}") String startDate;
    @QueryParam(value="numberOfInstallments")
    @Parameter(description="The number of installments for the re-aged loan", required=true)
    @NotNull(message="{org.apache.fineract.reage.number-of-installments.not-blank}")
    @Min(value=1L, message="{org.apache.fineract.reage.number-of-installments.min}")
    private @NotNull(message="{org.apache.fineract.reage.number-of-installments.not-blank}") @Min(value=1L, message="{org.apache.fineract.reage.number-of-installments.min}") Integer numberOfInstallments;
    @QueryParam(value="dateFormat")
    @Parameter(description="The date format used for the startDate parameter", required=true)
    @NotBlank(message="{org.apache.fineract.businessdate.date-format.not-blank}")
    private @NotBlank(message="{org.apache.fineract.businessdate.date-format.not-blank}") String dateFormat;
    @QueryParam(value="locale")
    @Parameter(description="The locale to use for formatting", required=true)
    @NotBlank(message="{org.apache.fineract.businessdate.locale.not-blank}")
    @Locale
    private @NotBlank(message="{org.apache.fineract.businessdate.locale.not-blank}") String locale;
    @QueryParam(value="reAgeInterestHandling")
    @Parameter(description="The interest handling type. Applied only for progressive interest-bearing loans. DEFAULT if not provided.")
    private String reAgeInterestHandling;

    @Generated
    public static ReAgePreviewRequestBuilder builder() {
        return new ReAgePreviewRequestBuilder();
    }

    @Generated
    public Integer getFrequencyNumber() {
        return this.frequencyNumber;
    }

    @Generated
    public String getFrequencyType() {
        return this.frequencyType;
    }

    @Generated
    public String getStartDate() {
        return this.startDate;
    }

    @Generated
    public Integer getNumberOfInstallments() {
        return this.numberOfInstallments;
    }

    @Generated
    public String getDateFormat() {
        return this.dateFormat;
    }

    @Generated
    public String getLocale() {
        return this.locale;
    }

    @Generated
    public String getReAgeInterestHandling() {
        return this.reAgeInterestHandling;
    }

    @Generated
    public void setFrequencyNumber(Integer frequencyNumber) {
        this.frequencyNumber = frequencyNumber;
    }

    @Generated
    public void setFrequencyType(String frequencyType) {
        this.frequencyType = frequencyType;
    }

    @Generated
    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    @Generated
    public void setNumberOfInstallments(Integer numberOfInstallments) {
        this.numberOfInstallments = numberOfInstallments;
    }

    @Generated
    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    @Generated
    public void setLocale(String locale) {
        this.locale = locale;
    }

    @Generated
    public void setReAgeInterestHandling(String reAgeInterestHandling) {
        this.reAgeInterestHandling = reAgeInterestHandling;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReAgePreviewRequest)) {
            return false;
        }
        ReAgePreviewRequest other = (ReAgePreviewRequest)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$frequencyNumber = this.getFrequencyNumber();
        Integer other$frequencyNumber = other.getFrequencyNumber();
        if (this$frequencyNumber == null ? other$frequencyNumber != null : !((Object)this$frequencyNumber).equals(other$frequencyNumber)) {
            return false;
        }
        Integer this$numberOfInstallments = this.getNumberOfInstallments();
        Integer other$numberOfInstallments = other.getNumberOfInstallments();
        if (this$numberOfInstallments == null ? other$numberOfInstallments != null : !((Object)this$numberOfInstallments).equals(other$numberOfInstallments)) {
            return false;
        }
        String this$frequencyType = this.getFrequencyType();
        String other$frequencyType = other.getFrequencyType();
        if (this$frequencyType == null ? other$frequencyType != null : !this$frequencyType.equals(other$frequencyType)) {
            return false;
        }
        String this$startDate = this.getStartDate();
        String other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !this$startDate.equals(other$startDate)) {
            return false;
        }
        String this$dateFormat = this.getDateFormat();
        String other$dateFormat = other.getDateFormat();
        if (this$dateFormat == null ? other$dateFormat != null : !this$dateFormat.equals(other$dateFormat)) {
            return false;
        }
        String this$locale = this.getLocale();
        String other$locale = other.getLocale();
        if (this$locale == null ? other$locale != null : !this$locale.equals(other$locale)) {
            return false;
        }
        String this$reAgeInterestHandling = this.getReAgeInterestHandling();
        String other$reAgeInterestHandling = other.getReAgeInterestHandling();
        return !(this$reAgeInterestHandling == null ? other$reAgeInterestHandling != null : !this$reAgeInterestHandling.equals(other$reAgeInterestHandling));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReAgePreviewRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $frequencyNumber = this.getFrequencyNumber();
        result = result * 59 + ($frequencyNumber == null ? 43 : ((Object)$frequencyNumber).hashCode());
        Integer $numberOfInstallments = this.getNumberOfInstallments();
        result = result * 59 + ($numberOfInstallments == null ? 43 : ((Object)$numberOfInstallments).hashCode());
        String $frequencyType = this.getFrequencyType();
        result = result * 59 + ($frequencyType == null ? 43 : $frequencyType.hashCode());
        String $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : $startDate.hashCode());
        String $dateFormat = this.getDateFormat();
        result = result * 59 + ($dateFormat == null ? 43 : $dateFormat.hashCode());
        String $locale = this.getLocale();
        result = result * 59 + ($locale == null ? 43 : $locale.hashCode());
        String $reAgeInterestHandling = this.getReAgeInterestHandling();
        result = result * 59 + ($reAgeInterestHandling == null ? 43 : $reAgeInterestHandling.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ReAgePreviewRequest(frequencyNumber=" + this.getFrequencyNumber() + ", frequencyType=" + this.getFrequencyType() + ", startDate=" + this.getStartDate() + ", numberOfInstallments=" + this.getNumberOfInstallments() + ", dateFormat=" + this.getDateFormat() + ", locale=" + this.getLocale() + ", reAgeInterestHandling=" + this.getReAgeInterestHandling() + ")";
    }

    @Generated
    public ReAgePreviewRequest() {
    }

    @Generated
    public ReAgePreviewRequest(Integer frequencyNumber, String frequencyType, String startDate, Integer numberOfInstallments, String dateFormat, String locale, String reAgeInterestHandling) {
        this.frequencyNumber = frequencyNumber;
        this.frequencyType = frequencyType;
        this.startDate = startDate;
        this.numberOfInstallments = numberOfInstallments;
        this.dateFormat = dateFormat;
        this.locale = locale;
        this.reAgeInterestHandling = reAgeInterestHandling;
    }
}

