/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanproduct.service;

import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.service.database.DatabaseSpecificSQLGenerator;
import org.apache.fineract.infrastructure.entityaccess.domain.FineractEntityType;
import org.apache.fineract.infrastructure.entityaccess.service.FineractEntityAccessUtil;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.charge.service.ChargeReadPlatformService;
import org.apache.fineract.portfolio.delinquency.service.DelinquencyReadPlatformService;
import org.apache.fineract.portfolio.loanproduct.data.AdvancedPaymentData;
import org.apache.fineract.portfolio.loanproduct.data.CreditAllocationData;
import org.apache.fineract.portfolio.loanproduct.data.LoanProductBorrowerCycleVariationData;
import org.apache.fineract.portfolio.loanproduct.data.LoanProductData;
import org.apache.fineract.portfolio.loanproduct.domain.LoanProduct;
import org.apache.fineract.portfolio.loanproduct.domain.LoanProductRepository;
import org.apache.fineract.portfolio.loanproduct.exception.LoanProductNotFoundException;
import org.apache.fineract.portfolio.loanproduct.service.LoanProductReadPlatformService;
import org.apache.fineract.portfolio.loanproduct.service.LoanProductReadPlatformServiceImpl;
import org.apache.fineract.portfolio.rate.service.RateReadService;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class LoanProductReadPlatformServiceImpl
implements LoanProductReadPlatformService {
    private final PlatformSecurityContext context;
    private final JdbcTemplate jdbcTemplate;
    private final ChargeReadPlatformService chargeReadPlatformService;
    private final RateReadService rateReadService;
    private final DatabaseSpecificSQLGenerator sqlGenerator;
    private final FineractEntityAccessUtil fineractEntityAccessUtil;
    private final DelinquencyReadPlatformService delinquencyReadPlatformService;
    private final LoanProductRepository loanProductRepository;

    public LoanProductData retrieveLoanProduct(Long loanProductId) {
        try {
            List charges = this.chargeReadPlatformService.retrieveLoanProductCharges(loanProductId);
            List rates = this.rateReadService.retrieveProductLoanRates(loanProductId);
            Collection borrowerCycleVariationDatas = this.retrieveLoanProductBorrowerCycleVariations(loanProductId);
            List advancedPaymentData = this.retrieveAdvancedPaymentData(loanProductId);
            List creditAllocationData = this.retrieveCreditAllocationData(loanProductId);
            List delinquencyBucketOptions = this.delinquencyReadPlatformService.retrieveAllDelinquencyBuckets();
            LoanProductMapper rm = new LoanProductMapper((Collection)charges, borrowerCycleVariationDatas, (Collection)rates, (Collection)delinquencyBucketOptions, (Collection)advancedPaymentData, (Collection)creditAllocationData);
            String sql = "select " + rm.loanProductSchema() + " where lp.id = ?";
            return (LoanProductData)this.jdbcTemplate.queryForObject(sql, (RowMapper)rm, new Object[]{loanProductId});
        }
        catch (EmptyResultDataAccessException e) {
            throw new LoanProductNotFoundException(loanProductId, e);
        }
    }

    public LoanProduct retrieveLoanProductByExternalId(ExternalId externalId) {
        LoanProduct loanProduct = this.loanProductRepository.findByExternalId(externalId);
        if (loanProduct == null) {
            throw new LoanProductNotFoundException(externalId);
        }
        return loanProduct;
    }

    public Collection<LoanProductBorrowerCycleVariationData> retrieveLoanProductBorrowerCycleVariations(Long loanProductId) {
        LoanProductBorrowerCycleMapper rm = new LoanProductBorrowerCycleMapper();
        String sql = "select " + rm.schema() + " where bc.loan_product_id=?  order by bc.borrower_cycle_number,bc.value_condition";
        return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{loanProductId});
    }

    public List<AdvancedPaymentData> retrieveAdvancedPaymentData(Long loanProductId) {
        AdvancedPaymentDataMapper apdm = new AdvancedPaymentDataMapper();
        String sql = "select " + apdm.schema() + " where loan_product_id = ?";
        return this.jdbcTemplate.query(sql, (RowMapper)apdm, new Object[]{loanProductId});
    }

    public List<CreditAllocationData> retrieveCreditAllocationData(Long loanProductId) {
        CreditAllocationDataMapper cadm = new CreditAllocationDataMapper();
        String sql = "select " + cadm.schema() + " where loan_product_id = ?";
        return this.jdbcTemplate.query(sql, (RowMapper)cadm, new Object[]{loanProductId});
    }

    public Collection<LoanProductData> retrieveAllLoanProducts() {
        this.context.authenticatedUser();
        LoanProductMapper rm = new LoanProductMapper(null, null, null, null, null, null);
        String sql = "select " + rm.loanProductSchema();
        String inClause = this.fineractEntityAccessUtil.getSQLWhereClauseForProductIDsForUserOffice_ifGlobalConfigEnabled(FineractEntityType.LOAN_PRODUCT);
        if (inClause != null && !inClause.trim().isEmpty()) {
            sql = sql + " where lp.id in ( " + inClause + " ) ";
        }
        return this.jdbcTemplate.query(sql, (RowMapper)rm);
    }

    public Collection<LoanProductData> retrieveAllLoanProductsForLookup(String inClause) {
        this.context.authenticatedUser();
        LoanProductLookupMapper rm = new LoanProductLookupMapper(this.sqlGenerator);
        String sql = "select " + rm.schema();
        if (inClause != null && !inClause.trim().isEmpty()) {
            sql = sql + " where lp.id in (" + inClause + ") ";
        }
        return this.jdbcTemplate.query(sql, (RowMapper)rm);
    }

    public Collection<LoanProductData> retrieveAllLoanProductsForLookup() {
        return this.retrieveAllLoanProductsForLookup(false);
    }

    public Collection<LoanProductData> retrieveAllLoanProductsForLookup(boolean activeOnly) {
        this.context.authenticatedUser();
        LoanProductLookupMapper rm = new LoanProductLookupMapper(this.sqlGenerator);
        Object sql = "select ";
        sql = activeOnly ? (String)sql + rm.activeOnlySchema() : (String)sql + rm.schema();
        String inClause = this.fineractEntityAccessUtil.getSQLWhereClauseForProductIDsForUserOffice_ifGlobalConfigEnabled(FineractEntityType.LOAN_PRODUCT);
        if (inClause != null && !inClause.trim().isEmpty()) {
            sql = activeOnly ? (String)sql + " and id in ( " + inClause + " )" : (String)sql + " where id in ( " + inClause + " ) ";
        }
        return this.jdbcTemplate.query((String)sql, (RowMapper)rm);
    }

    public LoanProductData retrieveNewLoanProductDetails() {
        return LoanProductData.sensibleDefaultsForNewLoanProductCreation();
    }

    public Collection<LoanProductData> retrieveAllLoanProductsForCurrency(String currencyCode) {
        this.context.authenticatedUser();
        LoanProductMapper rm = new LoanProductMapper(null, null, null, null, null, null);
        String sql = "select " + rm.loanProductSchema() + " where lp.currency_code= ? ";
        String inClause = this.fineractEntityAccessUtil.getSQLWhereClauseForProductIDsForUserOffice_ifGlobalConfigEnabled(FineractEntityType.LOAN_PRODUCT);
        if (inClause != null && !inClause.trim().isEmpty()) {
            sql = sql + " and id in (" + inClause + ") ";
        }
        return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{currencyCode});
    }

    public Collection<LoanProductData> retrieveAvailableLoanProductsForMix() {
        this.context.authenticatedUser();
        LoanProductLookupMapper rm = new LoanProductLookupMapper(this.sqlGenerator);
        String sql = "Select " + rm.productMixSchema();
        String inClause = this.fineractEntityAccessUtil.getSQLWhereClauseForProductIDsForUserOffice_ifGlobalConfigEnabled(FineractEntityType.LOAN_PRODUCT);
        if (inClause != null && !inClause.trim().isEmpty()) {
            sql = sql + " and lp.id in ( " + inClause + " ) ";
        }
        return this.jdbcTemplate.query(sql, (RowMapper)rm);
    }

    public Collection<LoanProductData> retrieveRestrictedProductsForMix(Long productId) {
        this.context.authenticatedUser();
        LoanProductLookupMapper rm = new LoanProductLookupMapper(this.sqlGenerator);
        String sql = "Select " + rm.restrictedProductsSchema() + " where pm.product_id=? ";
        String inClause1 = this.fineractEntityAccessUtil.getSQLWhereClauseForProductIDsForUserOffice_ifGlobalConfigEnabled(FineractEntityType.LOAN_PRODUCT);
        if (inClause1 != null && !inClause1.trim().isEmpty()) {
            sql = sql + " and rp.id in ( " + inClause1 + " ) ";
        }
        sql = sql + " UNION Select " + rm.derivedRestrictedProductsSchema() + " where pm.restricted_product_id=?";
        String inClause2 = this.fineractEntityAccessUtil.getSQLWhereClauseForProductIDsForUserOffice_ifGlobalConfigEnabled(FineractEntityType.LOAN_PRODUCT);
        if (inClause2 != null && !inClause2.trim().isEmpty()) {
            sql = sql + " and lp.id in ( " + inClause2 + " ) ";
        }
        return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{productId, productId});
    }

    public Collection<LoanProductData> retrieveAllowedProductsForMix(Long productId) {
        this.context.authenticatedUser();
        LoanProductLookupMapper rm = new LoanProductLookupMapper(this.sqlGenerator);
        String sql = "Select " + rm.schema() + " where ";
        String inClause = this.fineractEntityAccessUtil.getSQLWhereClauseForProductIDsForUserOffice_ifGlobalConfigEnabled(FineractEntityType.LOAN_PRODUCT);
        if (inClause != null && !inClause.trim().isEmpty()) {
            sql = sql + " lp.id in ( " + inClause + " ) and ";
        }
        sql = sql + "lp.id not in (Select pm.restricted_product_id from m_product_mix pm where pm.product_id=? UNION Select pm.product_id from m_product_mix pm where pm.restricted_product_id=?)";
        return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{productId, productId});
    }

    public LoanProductData retrieveLoanProductFloatingDetails(Long loanProductId) {
        try {
            LoanProductFloatingRateMapper rm = new LoanProductFloatingRateMapper();
            String sql = "select " + rm.schema() + " where lp.id = ?";
            return (LoanProductData)this.jdbcTemplate.queryForObject(sql, (RowMapper)rm, new Object[]{loanProductId});
        }
        catch (EmptyResultDataAccessException e) {
            throw new LoanProductNotFoundException(loanProductId, e);
        }
    }

    @Generated
    public LoanProductReadPlatformServiceImpl(PlatformSecurityContext context, JdbcTemplate jdbcTemplate, ChargeReadPlatformService chargeReadPlatformService, RateReadService rateReadService, DatabaseSpecificSQLGenerator sqlGenerator, FineractEntityAccessUtil fineractEntityAccessUtil, DelinquencyReadPlatformService delinquencyReadPlatformService, LoanProductRepository loanProductRepository) {
        this.context = context;
        this.jdbcTemplate = jdbcTemplate;
        this.chargeReadPlatformService = chargeReadPlatformService;
        this.rateReadService = rateReadService;
        this.sqlGenerator = sqlGenerator;
        this.fineractEntityAccessUtil = fineractEntityAccessUtil;
        this.delinquencyReadPlatformService = delinquencyReadPlatformService;
        this.loanProductRepository = loanProductRepository;
    }
}

