/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.savings.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.exception.UnrecognizedQueryParamException;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.core.serialization.JsonParserHelper;
import org.apache.fineract.infrastructure.core.service.PagedLocalRequest;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.paymenttype.service.PaymentTypeReadPlatformService;
import org.apache.fineract.portfolio.savings.DepositAccountType;
import org.apache.fineract.portfolio.savings.api.SavingsAccountTransactionsApiResourceSwagger;
import org.apache.fineract.portfolio.savings.api.SavingsApiSetConstants;
import org.apache.fineract.portfolio.savings.data.SavingsAccountTransactionData;
import org.apache.fineract.portfolio.savings.service.SavingsAccountReadPlatformService;
import org.apache.fineract.portfolio.savings.service.search.SavingsAccountTransactionSearchService;
import org.apache.fineract.portfolio.search.data.AdvancedQueryRequest;
import org.apache.fineract.portfolio.search.data.TransactionSearchRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;

@Path(value="/v1/savingsaccounts/{savingsId}/transactions")
@Component
@Tag(name="Savings Account Transactions", description="")
public class SavingsAccountTransactionsApiResource {
    private final PlatformSecurityContext context;
    private final DefaultToApiJsonSerializer<SavingsAccountTransactionData> toApiJsonSerializer;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final SavingsAccountReadPlatformService savingsAccountReadPlatformService;
    private final PaymentTypeReadPlatformService paymentTypeReadPlatformService;
    private final SavingsAccountTransactionSearchService transactionsSearchService;

    private boolean is(String commandParam, String commandValue) {
        return StringUtils.isNotBlank((CharSequence)commandParam) && commandParam.trim().equalsIgnoreCase(commandValue);
    }

    @GET
    @Path(value="template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String retrieveTemplate(@PathParam(value="savingsId") Long savingsId, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("savingsaccount");
        SavingsAccountTransactionData savingsAccount = this.savingsAccountReadPlatformService.retrieveDepositTransactionTemplate(savingsId, DepositAccountType.SAVINGS_DEPOSIT);
        List paymentTypeOptions = this.paymentTypeReadPlatformService.retrieveAllPaymentTypes();
        savingsAccount = SavingsAccountTransactionData.templateOnTop((SavingsAccountTransactionData)savingsAccount, (Collection)paymentTypeOptions);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Object)savingsAccount, SavingsApiSetConstants.SAVINGS_TRANSACTION_RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Path(value="{transactionId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String retrieveOne(@PathParam(value="savingsId") Long savingsId, @PathParam(value="transactionId") Long transactionId, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("savingsaccount");
        SavingsAccountTransactionData transactionData = this.savingsAccountReadPlatformService.retrieveSavingsTransaction(savingsId, transactionId, DepositAccountType.SAVINGS_DEPOSIT);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        if (settings.isTemplate()) {
            List paymentTypeOptions = this.paymentTypeReadPlatformService.retrieveAllPaymentTypes();
            transactionData = SavingsAccountTransactionData.templateOnTop((SavingsAccountTransactionData)transactionData, (Collection)paymentTypeOptions);
        }
        return this.toApiJsonSerializer.serialize(settings, (Object)transactionData, SavingsApiSetConstants.SAVINGS_TRANSACTION_RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Path(value="search")
    @Produces(value={"application/json"})
    @Operation(summary="Search Savings Account Transactions")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SavingsAccountTransactionsApiResourceSwagger.SavingsAccountTransactionsSearchResponse.class))})})
    public String searchTransactions(@PathParam(value="savingsId") @Parameter(description="savings account id") Long savingsId, @QueryParam(value="fromDate") @Parameter(description="minimum value date (inclusive)", example="2023-08-08") String fromDate, @QueryParam(value="toDate") @Parameter(description="maximum value date (inclusive)", example="2023-08-15") String toDate, @QueryParam(value="fromSubmittedDate") @Parameter(description="minimum booking date (inclusive)", example="2023-08-08") String fromSubmittedDate, @QueryParam(value="toSubmittedDate") @Parameter(description="maximum booking date (inclusive)", example="2023-08-15") String toSubmittedDate, @QueryParam(value="fromAmount") @Parameter(description="minimum transaction amount (inclusive)", example="1000") BigDecimal fromAmount, @QueryParam(value="toAmount") @Parameter(description="maximum transaction amount (inclusive)", example="50000000") BigDecimal toAmount, @QueryParam(value="types") @Parameter(description="transaction types", example="1,2,4,20,21") String types, @QueryParam(value="credit") @Parameter(description="credit") Boolean credit, @QueryParam(value="debit") @Parameter(description="debit") Boolean debit, @QueryParam(value="offset") @Parameter(description="offset") Integer offset, @QueryParam(value="limit") @Parameter(description="limit") Integer limit, @QueryParam(value="orderBy") @Parameter(description="sort properties", example="createdDate,transactionDate,id") String orderBy, @QueryParam(value="sortOrder") @Parameter(description="sort direction") Sort.Direction sortOrder, @QueryParam(value="locale") @Parameter(description="locale") String localeString, @QueryParam(value="dateFormat") @Parameter(description="date format", example="yyyy-MM-dd") String dateFormat) {
        Locale locale = localeString == null ? null : JsonParserHelper.localeFromString((String)localeString);
        TransactionSearchRequest searchParameters = new TransactionSearchRequest().accountId(savingsId).fromDate(fromDate, dateFormat, locale).toDate(toDate, dateFormat, locale).fromSubmittedDate(fromSubmittedDate, dateFormat, locale).toSubmittedDate(toSubmittedDate, dateFormat, locale).fromAmount(fromAmount).toAmount(toAmount).types(types).credit(credit).debit(debit).pageable(offset, limit, orderBy, sortOrder);
        Page transactionsData = this.transactionsSearchService.searchTransactions(savingsId, searchParameters);
        return this.toApiJsonSerializer.serialize((Object)transactionsData);
    }

    @POST
    @Path(value="query")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Advanced search Savings Account Transactions")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=List.class))})})
    public String advancedQuery(@PathParam(value="savingsId") @Parameter(description="savingsId") Long savingsId, PagedLocalRequest<AdvancedQueryRequest> queryRequest, @Context UriInfo uriInfo) {
        Page result = this.transactionsSearchService.queryAdvanced(savingsId, queryRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=SavingsAccountTransactionsApiResourceSwagger.PostSavingsAccountTransactionsRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SavingsAccountTransactionsApiResourceSwagger.PostSavingsAccountTransactionsResponse.class))})})
    public String transaction(@PathParam(value="savingsId") Long savingsId, @QueryParam(value="command") String commandParam, String apiRequestBodyAsJson) {
        CommandWrapperBuilder builder = new CommandWrapperBuilder().withJson(apiRequestBodyAsJson);
        CommandProcessingResult result = null;
        if (this.is(commandParam, "deposit")) {
            CommandWrapper commandRequest = builder.savingsAccountDeposit(savingsId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else if (this.is(commandParam, "gsimDeposit")) {
            CommandWrapper commandRequest = builder.gsimSavingsAccountDeposit(savingsId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else if (this.is(commandParam, "withdrawal")) {
            CommandWrapper commandRequest = builder.savingsAccountWithdrawal(savingsId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else if (this.is(commandParam, "postInterestAsOn")) {
            CommandWrapper commandRequest = builder.savingsAccountInterestPosting(savingsId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else if (this.is(commandParam, "holdAmount")) {
            CommandWrapper commandRequest = builder.holdAmount(savingsId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        }
        if (result == null) {
            throw new UnrecognizedQueryParamException("command", commandParam, new Object[]{"deposit", "withdrawal", "holdAmount"});
        }
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @POST
    @Path(value="{transactionId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Undo/Reverse/Modify/Release Amount transaction API", description="Undo/Reverse/Modify/Release Amount transaction API\n\nExample Requests:\n\n\nsavingsaccounts/{savingsId}/transactions/{transactionId}?command=reverse\n\nAccepted command = undo, reverse, modify, releaseAmount")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=SavingsAccountTransactionsApiResourceSwagger.PostSavingsAccountBulkReversalTransactionsRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=SavingsAccountTransactionsApiResourceSwagger.PostSavingsAccountBulkReversalTransactionsRequest.class)))})})
    public String adjustTransaction(@PathParam(value="savingsId") Long savingsId, @PathParam(value="transactionId") Long transactionId, @QueryParam(value="command") String commandParam, String apiRequestBodyAsJson) {
        String jsonApiRequest = apiRequestBodyAsJson;
        if (StringUtils.isBlank((CharSequence)jsonApiRequest)) {
            jsonApiRequest = "{}";
        }
        CommandWrapperBuilder builder = new CommandWrapperBuilder().withJson(jsonApiRequest);
        CommandProcessingResult result = null;
        if (this.is(commandParam, "undo")) {
            CommandWrapper commandRequest = builder.undoSavingsAccountTransaction(savingsId, transactionId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else if (this.is(commandParam, "reverse")) {
            CommandWrapper commandRequest = builder.reverseSavingsAccountTransaction(savingsId, transactionId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else if (this.is(commandParam, "modify")) {
            CommandWrapper commandRequest = builder.adjustSavingsAccountTransaction(savingsId, transactionId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else if (this.is(commandParam, "releaseAmount")) {
            CommandWrapper commandRequest = builder.releaseAmount(savingsId, transactionId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        }
        if (result == null) {
            throw new UnrecognizedQueryParamException("command", commandParam, new Object[]{"undo", "modify", "releaseAmount", "reverse"});
        }
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @Generated
    public SavingsAccountTransactionsApiResource(PlatformSecurityContext context, DefaultToApiJsonSerializer<SavingsAccountTransactionData> toApiJsonSerializer, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, ApiRequestParameterHelper apiRequestParameterHelper, SavingsAccountReadPlatformService savingsAccountReadPlatformService, PaymentTypeReadPlatformService paymentTypeReadPlatformService, SavingsAccountTransactionSearchService transactionsSearchService) {
        this.context = context;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.savingsAccountReadPlatformService = savingsAccountReadPlatformService;
        this.paymentTypeReadPlatformService = paymentTypeReadPlatformService;
        this.transactionsSearchService = transactionsSearchService;
    }
}

