/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.self.pockets.service;

import lombok.Generated;
import org.apache.fineract.infrastructure.accountnumberformat.domain.EntityAccountType;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.accounts.exceptions.ShareAccountNotFoundException;
import org.apache.fineract.portfolio.self.pockets.service.AccountEntityService;
import org.apache.fineract.portfolio.self.shareaccounts.service.AppUserShareAccountsMapperReadPlatformService;
import org.apache.fineract.portfolio.shareaccounts.service.ShareAccountReadPlatformService;

public class AccountEntityServiceForShareAccountsImpl
implements AccountEntityService {
    private static final String KEY = EntityAccountType.SHARES.name();
    private final PlatformSecurityContext context;
    private final AppUserShareAccountsMapperReadPlatformService appUserShareAccountsMapperReadPlatformService;
    private final ShareAccountReadPlatformService shareAccountReadPlatformService;

    public String getKey() {
        return KEY;
    }

    public void validateSelfUserAccountMapping(Long accountId) {
        if (!this.appUserShareAccountsMapperReadPlatformService.isShareAccountsMappedToUser(accountId, (Long)this.context.authenticatedUser().getId()).booleanValue()) {
            throw new ShareAccountNotFoundException(accountId);
        }
    }

    public String retrieveAccountNumberByAccountId(Long accountId) {
        return this.shareAccountReadPlatformService.retrieveAccountNumberByAccountId(accountId);
    }

    @Generated
    public AccountEntityServiceForShareAccountsImpl(PlatformSecurityContext context, AppUserShareAccountsMapperReadPlatformService appUserShareAccountsMapperReadPlatformService, ShareAccountReadPlatformService shareAccountReadPlatformService) {
        this.context = context;
        this.appUserShareAccountsMapperReadPlatformService = appUserShareAccountsMapperReadPlatformService;
        this.shareAccountReadPlatformService = shareAccountReadPlatformService;
    }
}

