/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.table.runtime.operators.multipleinput.output;

import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.RecordAttributes;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.watermarkstatus.WatermarkStatus;
import org.apache.flink.table.data.RowData;
import org.apache.flink.util.OutputTag;

/** A {@link Output} for testing which does not output anything. */
public class BlackHoleOutput implements Output<StreamRecord<RowData>> {

    @Override
    public void emitWatermark(Watermark mark) {
        // do nothing
    }

    @Override
    public void emitWatermarkStatus(WatermarkStatus watermarkStatus) {
        // do nothing
    }

    @Override
    public <X> void collect(OutputTag<X> outputTag, StreamRecord<X> record) {
        // do nothing
    }

    @Override
    public void emitLatencyMarker(LatencyMarker latencyMarker) {
        // do nothing
    }

    @Override
    public void emitRecordAttributes(RecordAttributes recordAttributes) {
        // do nothing
    }

    @Override
    public void collect(StreamRecord<RowData> record) {
        // do nothing
    }

    @Override
    public void close() {
        // do nothing
    }
}
