/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.statsd;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Histogram;
import org.apache.flink.metrics.HistogramStatistics;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.MetricConfig;
import org.apache.flink.metrics.reporter.AbstractReporter;
import org.apache.flink.metrics.reporter.Scheduled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicEvolving
public class StatsDReporter
extends AbstractReporter
implements Scheduled {
    private static final Logger LOG = LoggerFactory.getLogger(StatsDReporter.class);
    public static final String ARG_HOST = "host";
    public static final String ARG_PORT = "port";
    private boolean closed = false;
    private DatagramSocket socket;
    private InetSocketAddress address;

    public void open(MetricConfig config) {
        String host = config.getString(ARG_HOST, null);
        int port = config.getInteger(ARG_PORT, -1);
        if (host == null || host.length() == 0 || port < 1) {
            throw new IllegalArgumentException("Invalid host/port configuration. Host: " + host + " Port: " + port);
        }
        this.address = new InetSocketAddress(host, port);
        try {
            this.socket = new DatagramSocket(0);
        }
        catch (SocketException e) {
            throw new RuntimeException("Could not create datagram socket. ", e);
        }
        this.log.info("Configured StatsDReporter with {host:{}, port:{}}", (Object)host, (Object)port);
    }

    public void close() {
        this.closed = true;
        if (this.socket != null && !this.socket.isClosed()) {
            this.socket.close();
        }
    }

    public void report() {
        try {
            for (Map.Entry entry : this.gauges.entrySet()) {
                if (this.closed) {
                    return;
                }
                this.reportGauge((String)entry.getValue(), (Gauge)entry.getKey());
            }
            for (Map.Entry entry : this.counters.entrySet()) {
                if (this.closed) {
                    return;
                }
                this.reportCounter((String)entry.getValue(), (Counter)entry.getKey());
            }
            for (Map.Entry entry : this.histograms.entrySet()) {
                this.reportHistogram((String)entry.getValue(), (Histogram)entry.getKey());
            }
            for (Map.Entry entry : this.meters.entrySet()) {
                this.reportMeter((String)entry.getValue(), (Meter)entry.getKey());
            }
        }
        catch (ConcurrentModificationException | NoSuchElementException runtimeException) {
            // empty catch block
        }
    }

    private void reportCounter(String name, Counter counter) {
        this.send(name, counter.getCount());
    }

    private void reportGauge(String name, Gauge<?> gauge) {
        Object value = gauge.getValue();
        if (value == null) {
            return;
        }
        if (value instanceof Number) {
            this.send(this.numberIsNegative((Number)value), name, value.toString());
        }
        this.send(name, value.toString());
    }

    private void reportHistogram(String name, Histogram histogram) {
        HistogramStatistics statistics;
        if (histogram != null && (statistics = histogram.getStatistics()) != null) {
            this.send(this.prefix(name, "count"), histogram.getCount());
            this.send(this.prefix(name, "max"), statistics.getMax());
            this.send(this.prefix(name, "min"), statistics.getMin());
            this.send(this.prefix(name, "mean"), statistics.getMean());
            this.send(this.prefix(name, "stddev"), statistics.getStdDev());
            this.send(this.prefix(name, "p50"), statistics.getQuantile(0.5));
            this.send(this.prefix(name, "p75"), statistics.getQuantile(0.75));
            this.send(this.prefix(name, "p95"), statistics.getQuantile(0.95));
            this.send(this.prefix(name, "p98"), statistics.getQuantile(0.98));
            this.send(this.prefix(name, "p99"), statistics.getQuantile(0.99));
            this.send(this.prefix(name, "p999"), statistics.getQuantile(0.999));
        }
    }

    private void reportMeter(String name, Meter meter) {
        if (meter != null) {
            this.send(this.prefix(name, "rate"), meter.getRate());
            this.send(this.prefix(name, "count"), meter.getCount());
        }
    }

    private String prefix(String ... names) {
        if (names.length > 0) {
            StringBuilder stringBuilder = new StringBuilder(names[0]);
            for (int i = 1; i < names.length; ++i) {
                stringBuilder.append('.').append(names[i]);
            }
            return stringBuilder.toString();
        }
        return "";
    }

    private void send(String name, double value) {
        this.send(this.numberIsNegative(value), name, String.valueOf(value));
    }

    private void send(String name, long value) {
        this.send(value < 0L, name, String.valueOf(value));
    }

    private void send(boolean resetToZero, String name, String value) {
        if (resetToZero) {
            this.send(name, "0");
        }
        this.send(name, value);
    }

    private void send(String name, String value) {
        try {
            String formatted = String.format("%s:%s|g", name, value);
            byte[] data = formatted.getBytes(StandardCharsets.UTF_8);
            this.socket.send(new DatagramPacket(data, data.length, this.address));
        }
        catch (IOException e) {
            LOG.error("unable to send packet to statsd at '{}:{}'", (Object)this.address.getHostName(), (Object)this.address.getPort());
        }
    }

    public String filterCharacters(String input) {
        char[] chars = null;
        int strLen = input.length();
        int pos = 0;
        block3: for (int i = 0; i < strLen; ++i) {
            char c = input.charAt(i);
            switch (c) {
                case ':': {
                    if (chars == null) {
                        chars = input.toCharArray();
                    }
                    chars[pos++] = 45;
                    continue block3;
                }
                default: {
                    if (chars != null) {
                        chars[pos] = c;
                    }
                    ++pos;
                }
            }
        }
        return chars == null ? input : new String(chars, 0, pos);
    }

    private boolean numberIsNegative(Number input) {
        return Double.compare(input.doubleValue(), 0.0) < 0;
    }
}

