/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.scalar;

import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.table.functions.SpecializedFunction;
import org.apache.flink.table.runtime.functions.scalar.BuiltInScalarFunction;
import org.apache.flink.table.types.CollectionDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.FlinkRuntimeException;

@Internal
public class ArrayRemoveFunction
extends BuiltInScalarFunction {
    private final ArrayData.ElementGetter elementGetter;
    private final SpecializedFunction.ExpressionEvaluator equalityEvaluator;
    private transient MethodHandle equalityHandle;

    public ArrayRemoveFunction(SpecializedFunction.SpecializedContext context) {
        super(BuiltInFunctionDefinitions.ARRAY_REMOVE, context);
        DataType elementDataType = ((CollectionDataType)context.getCallContext().getArgumentDataTypes().get(0)).getElementDataType();
        DataType needleDataType = (DataType)context.getCallContext().getArgumentDataTypes().get(1);
        this.elementGetter = ArrayData.createElementGetter((LogicalType)elementDataType.getLogicalType());
        this.equalityEvaluator = context.createEvaluator((Expression)Expressions.$((String)"element").isEqual((Object)Expressions.$((String)"needle")), DataTypes.BOOLEAN(), new DataTypes.Field[]{DataTypes.FIELD((String)"element", (DataType)((DataType)elementDataType.notNull()).toInternal()), DataTypes.FIELD((String)"needle", (DataType)((DataType)needleDataType.notNull()).toInternal())});
    }

    public void open(FunctionContext context) throws Exception {
        this.equalityHandle = this.equalityEvaluator.open(context);
    }

    @Nullable
    public ArrayData eval(ArrayData haystack, Object needle) {
        try {
            if (haystack == null) {
                return null;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            int size = haystack.size();
            for (int pos = 0; pos < size; ++pos) {
                Object element = this.elementGetter.getElementOrNull(haystack, pos);
                if (element == null && needle == null || element != null && needle != null && this.equalityHandle.invoke(element, needle)) continue;
                list.add(element);
            }
            return new GenericArrayData(list.toArray());
        }
        catch (Throwable t) {
            throw new FlinkRuntimeException(t);
        }
    }

    public void close() throws Exception {
        this.equalityEvaluator.close();
    }
}

