/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.table;

import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.SpecializedFunction;
import org.apache.flink.table.runtime.functions.table.BuiltInTableFunction;

@Internal
public class ReplicateRowsFunction
extends BuiltInTableFunction<RowData> {
    private static final long serialVersionUID = 1L;

    public ReplicateRowsFunction(SpecializedFunction.SpecializedContext specializedContext) {
        super(BuiltInFunctionDefinitions.INTERNAL_REPLICATE_ROWS, specializedContext);
    }

    public void eval(Object ... inputs) {
        int i;
        long replication = (Long)inputs[0];
        int rowLength = inputs.length - 1;
        GenericRowData row = new GenericRowData(rowLength);
        for (i = 0; i < rowLength; ++i) {
            row.setField(i, inputs[i + 1]);
        }
        i = 0;
        while ((long)i < replication) {
            this.collect(row);
            ++i;
        }
    }
}

