/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.deduplicate;

import org.apache.flink.api.common.state.StateTtlConfig;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.runtime.context.ExecutionContext;
import org.apache.flink.table.runtime.operators.bundle.MapBundleFunction;
import org.apache.flink.table.runtime.util.StateConfigUtil;

abstract class MiniBatchDeduplicateFunctionBase<T, K, V, IN, OUT>
extends MapBundleFunction<K, V, IN, OUT> {
    private static final long serialVersionUID = 1L;
    protected final TypeInformation<T> stateType;
    protected final long minRetentionTime;
    protected ValueState<T> state;

    public MiniBatchDeduplicateFunctionBase(TypeInformation<T> stateType, long minRetentionTime) {
        this.stateType = stateType;
        this.minRetentionTime = minRetentionTime;
    }

    @Override
    public void open(ExecutionContext ctx) throws Exception {
        super.open(ctx);
        ValueStateDescriptor stateDesc = new ValueStateDescriptor("deduplicate-state", this.stateType);
        StateTtlConfig ttlConfig = StateConfigUtil.createTtlConfig(this.minRetentionTime);
        if (ttlConfig.isEnabled()) {
            stateDesc.enableTimeToLive(ttlConfig);
        }
        this.state = ctx.getRuntimeContext().getState(stateDesc);
    }
}

