/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.match;

import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.cep.pattern.conditions.IterativeCondition;
import org.apache.flink.cep.pattern.conditions.RichIterativeCondition;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.GeneratedFunction;

public class IterativeConditionRunner
extends RichIterativeCondition<RowData> {
    private static final long serialVersionUID = 1L;
    private final GeneratedFunction<RichIterativeCondition<RowData>> generatedFunction;
    private transient RichIterativeCondition<RowData> function;

    public IterativeConditionRunner(GeneratedFunction<RichIterativeCondition<RowData>> generatedFunction) {
        this.generatedFunction = generatedFunction;
    }

    public void open(OpenContext openContext) throws Exception {
        this.function = (RichIterativeCondition)this.generatedFunction.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
        FunctionUtils.setFunctionRuntimeContext(this.function, (RuntimeContext)this.getRuntimeContext());
        FunctionUtils.openFunction(this.function, (OpenContext)openContext);
    }

    public boolean filter(RowData value, IterativeCondition.Context<RowData> ctx) throws Exception {
        return this.function.filter((Object)value, ctx);
    }

    public void close() throws Exception {
        FunctionUtils.closeFunction(this.function);
    }
}

