/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.multipleinput.output;

import java.util.Random;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.RecordAttributes;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.watermarkstatus.WatermarkStatus;
import org.apache.flink.table.data.RowData;
import org.apache.flink.util.OutputTag;
import org.apache.flink.util.XORShiftRandom;

public class BroadcastingOutput
implements Output<StreamRecord<RowData>> {
    protected final Output<StreamRecord<RowData>>[] outputs;
    private final Random random = new XORShiftRandom();

    public BroadcastingOutput(Output<StreamRecord<RowData>>[] outputs) {
        this.outputs = outputs;
    }

    public void emitWatermark(Watermark mark) {
        for (Output<StreamRecord<RowData>> output : this.outputs) {
            output.emitWatermark(mark);
        }
    }

    public void emitWatermarkStatus(WatermarkStatus watermarkStatus) {
        for (Output<StreamRecord<RowData>> output : this.outputs) {
            output.emitWatermarkStatus(watermarkStatus);
        }
    }

    public <X> void collect(OutputTag<X> outputTag, StreamRecord<X> record) {
        for (Output<StreamRecord<RowData>> output : this.outputs) {
            output.collect(outputTag, record);
        }
    }

    public void emitLatencyMarker(LatencyMarker latencyMarker) {
        if (this.outputs.length > 0) {
            if (this.outputs.length == 1) {
                this.outputs[0].emitLatencyMarker(latencyMarker);
            } else {
                this.outputs[this.random.nextInt(this.outputs.length)].emitLatencyMarker(latencyMarker);
            }
        }
    }

    public void collect(StreamRecord<RowData> record) {
        for (Output<StreamRecord<RowData>> output : this.outputs) {
            output.collect(record);
        }
    }

    public void close() {
        for (Output<StreamRecord<RowData>> output : this.outputs) {
            output.close();
        }
    }

    public void emitRecordAttributes(RecordAttributes recordAttributes) {
        for (Output<StreamRecord<RowData>> output : this.outputs) {
            output.emitRecordAttributes(recordAttributes);
        }
    }
}

