/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.over;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.runtime.dataview.PerKeyStateDataViewStore;
import org.apache.flink.table.runtime.functions.KeyedProcessFunctionWithCleanupState;
import org.apache.flink.table.runtime.generated.AggsHandleFunction;
import org.apache.flink.table.runtime.generated.GeneratedAggsHandleFunction;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcTimeRowsBoundedPrecedingFunction<K>
extends KeyedProcessFunctionWithCleanupState<K, RowData, RowData> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(ProcTimeRowsBoundedPrecedingFunction.class);
    private final GeneratedAggsHandleFunction genAggsHandler;
    private final LogicalType[] accTypes;
    private final LogicalType[] inputFieldTypes;
    private final long precedingOffset;
    private transient AggsHandleFunction function;
    private transient ValueState<RowData> accState;
    private transient MapState<Long, List<RowData>> inputState;
    private transient ValueState<Long> counterState;
    private transient ValueState<Long> smallestTsState;
    private transient JoinedRowData output;

    public ProcTimeRowsBoundedPrecedingFunction(long minRetentionTime, long maxRetentionTime, GeneratedAggsHandleFunction genAggsHandler, LogicalType[] accTypes, LogicalType[] inputFieldTypes, long precedingOffset) {
        super(minRetentionTime, maxRetentionTime);
        Preconditions.checkArgument((precedingOffset > 0L ? 1 : 0) != 0);
        this.genAggsHandler = genAggsHandler;
        this.accTypes = accTypes;
        this.inputFieldTypes = inputFieldTypes;
        this.precedingOffset = precedingOffset;
    }

    public void open(OpenContext openContext) throws Exception {
        this.function = (AggsHandleFunction)this.genAggsHandler.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
        this.function.open(new PerKeyStateDataViewStore(this.getRuntimeContext()));
        this.output = new JoinedRowData();
        InternalTypeInfo<RowData> inputType = InternalTypeInfo.ofFields(this.inputFieldTypes);
        ListTypeInfo rowListTypeInfo = new ListTypeInfo(inputType);
        MapStateDescriptor mapStateDescriptor = new MapStateDescriptor("inputState", (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO, (TypeInformation)rowListTypeInfo);
        this.inputState = this.getRuntimeContext().getMapState(mapStateDescriptor);
        InternalTypeInfo<RowData> accTypeInfo = InternalTypeInfo.ofFields(this.accTypes);
        ValueStateDescriptor stateDescriptor = new ValueStateDescriptor("accState", accTypeInfo);
        this.accState = this.getRuntimeContext().getState(stateDescriptor);
        ValueStateDescriptor processedCountDescriptor = new ValueStateDescriptor("processedCountState", Types.LONG);
        this.counterState = this.getRuntimeContext().getState(processedCountDescriptor);
        ValueStateDescriptor smallestTimestampDescriptor = new ValueStateDescriptor("smallestTSState", Types.LONG);
        this.smallestTsState = this.getRuntimeContext().getState(smallestTimestampDescriptor);
        this.initCleanupTimeState("ProcTimeBoundedRowsOverCleanupTime");
    }

    public void processElement(RowData input, KeyedProcessFunction.Context ctx, Collector<RowData> out) throws Exception {
        Long counter;
        long currentTime = ctx.timerService().currentProcessingTime();
        this.registerProcessingCleanupTimer(ctx, currentTime);
        RowData accumulators = (RowData)this.accState.value();
        if (accumulators == null) {
            accumulators = this.function.createAccumulators();
        }
        this.function.setAccumulators(accumulators);
        Long smallestTs = (Long)this.smallestTsState.value();
        if (smallestTs == null) {
            smallestTs = currentTime;
            this.smallestTsState.update((Object)smallestTs);
        }
        if ((counter = (Long)this.counterState.value()) == null) {
            counter = 0L;
        }
        if (counter == this.precedingOffset) {
            List retractList = (List)this.inputState.get((Object)smallestTs);
            if (retractList != null) {
                RowData retractRow = (RowData)retractList.get(0);
                this.function.retract(retractRow);
                retractList.remove(0);
            } else {
                LOG.warn("The state is cleared because of state ttl. This will result in incorrect result. You can increase the state ttl to avoid this.");
            }
            if (retractList != null && !retractList.isEmpty()) {
                this.inputState.put((Object)smallestTs, (Object)retractList);
            } else {
                this.inputState.remove((Object)smallestTs);
                Iterator iter = this.inputState.keys().iterator();
                long currentTs = 0L;
                long newSmallestTs = Long.MAX_VALUE;
                while (iter.hasNext()) {
                    currentTs = (Long)iter.next();
                    if (currentTs >= newSmallestTs) continue;
                    newSmallestTs = currentTs;
                }
                this.smallestTsState.update((Object)newSmallestTs);
            }
        } else {
            counter = counter + 1L;
            this.counterState.update((Object)counter);
        }
        List currentTimeState = (List)this.inputState.get((Object)currentTime);
        if (currentTimeState != null) {
            currentTimeState.add(input);
            this.inputState.put((Object)currentTime, (Object)currentTimeState);
        } else {
            ArrayList<RowData> newList = new ArrayList<RowData>();
            newList.add(input);
            this.inputState.put((Object)currentTime, newList);
        }
        this.function.accumulate(input);
        accumulators = this.function.getAccumulators();
        this.accState.update((Object)accumulators);
        RowData aggValue = this.function.getValue();
        this.output.replace(input, aggValue);
        out.collect((Object)this.output);
    }

    public void onTimer(long timestamp, KeyedProcessFunction.OnTimerContext ctx, Collector<RowData> out) throws Exception {
        if (this.stateCleaningEnabled) {
            this.cleanupState(new State[]{this.inputState, this.accState, this.counterState, this.smallestTsState});
            this.function.cleanup();
        }
    }

    public void close() throws Exception {
        if (null != this.function) {
            this.function.close();
        }
    }
}

