/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.json;

import java.io.Serializable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.util.function.SerializableSupplier;

@PublicEvolving
public class JsonSerializationSchema<T>
implements SerializationSchema<T> {
    private static final long serialVersionUID = 1L;
    private final SerializableSupplier<ObjectMapper> mapperFactory;
    protected transient ObjectMapper mapper;

    public JsonSerializationSchema() {
        this((SerializableSupplier<ObjectMapper>)(SerializableSupplier & Serializable)() -> new ObjectMapper());
    }

    public JsonSerializationSchema(SerializableSupplier<ObjectMapper> mapperFactory) {
        this.mapperFactory = mapperFactory;
    }

    public void open(SerializationSchema.InitializationContext context) {
        this.mapper = (ObjectMapper)this.mapperFactory.get();
    }

    public byte[] serialize(T element) {
        try {
            return this.mapper.writeValueAsBytes(element);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(String.format("Could not serialize value '%s'.", element), e);
        }
    }
}

