/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.dataview;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeinfo.TypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.dataview.DataView;
import org.apache.flink.table.dataview.ListViewTypeInfoFactory;
import org.apache.flink.table.types.DataType;

@TypeInfo(value=ListViewTypeInfoFactory.class)
@PublicEvolving
public class ListView<T>
implements DataView {
    private List<T> list = new ArrayList<T>();
    @Deprecated
    public transient TypeInformation<?> elementType;

    public ListView() {
    }

    public List<T> getList() {
        return this.list;
    }

    public void setList(List<T> list) {
        this.list = list;
    }

    public Iterable<T> get() throws Exception {
        return this.list;
    }

    public void add(T value) throws Exception {
        this.list.add(value);
    }

    public void addAll(List<T> list) throws Exception {
        this.list.addAll(list);
    }

    public boolean remove(T value) throws Exception {
        return this.list.remove(value);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListView)) {
            return false;
        }
        ListView listView = (ListView)o;
        return this.getList().equals(listView.getList());
    }

    public int hashCode() {
        return Objects.hash(this.getList());
    }

    public static DataType newListViewDataType(DataType elementDataType) {
        return DataTypes.STRUCTURED(ListView.class, DataTypes.FIELD("list", (DataType)DataTypes.ARRAY(elementDataType).bridgedTo(List.class)));
    }

    @Deprecated
    public ListView(TypeInformation<?> elementType) {
        this.elementType = elementType;
    }
}

