/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.internal;

import java.util.NoSuchElementException;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.internal.ResultProvider;
import org.apache.flink.table.api.internal.StaticResultProvider;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.utils.print.RowDataToStringConverter;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;

@Internal
class InsertResultProvider
implements ResultProvider {
    private final Long[] affectedRowCountsRow;
    @Nullable
    private Boolean hasNext = null;
    private JobClient jobClient;

    InsertResultProvider(Long[] affectedRowCountsRow) {
        this.affectedRowCountsRow = affectedRowCountsRow;
    }

    @Override
    public InsertResultProvider setJobClient(JobClient jobClient) {
        this.jobClient = jobClient;
        return this;
    }

    @Override
    public CloseableIterator<RowData> toInternalIterator() {
        return new Iterator<RowData>(() -> GenericRowData.of(this.affectedRowCountsRow));
    }

    @Override
    public CloseableIterator<Row> toExternalIterator() {
        return new Iterator<Row>(() -> Row.of((Object[])this.affectedRowCountsRow));
    }

    @Override
    public RowDataToStringConverter getRowDataStringConverter() {
        return StaticResultProvider.SIMPLE_ROW_DATA_TO_STRING_CONVERTER;
    }

    @Override
    public boolean isFirstRowReady() {
        return this.hasNext != null || this.hasNext();
    }

    private void close() throws Exception {
        if (this.jobClient != null) {
            this.jobClient.cancel();
        }
    }

    private boolean hasNext() {
        if (this.hasNext == null) {
            try {
                this.jobClient.getJobExecutionResult().get();
            }
            catch (Exception e) {
                throw new TableException("Failed to wait job finish", e);
            }
            this.hasNext = true;
        }
        return this.hasNext;
    }

    @Override
    public void reset() {
        this.hasNext = null;
        this.jobClient = null;
    }

    private class Iterator<T>
    implements CloseableIterator<T> {
        private final Supplier<T> rowSupplier;

        private Iterator(Supplier<T> rowSupplier) {
            this.rowSupplier = rowSupplier;
        }

        public void close() throws Exception {
            InsertResultProvider.this.close();
        }

        public boolean hasNext() {
            return InsertResultProvider.this.hasNext();
        }

        public T next() {
            if (this.hasNext()) {
                InsertResultProvider.this.hasNext = false;
                return this.rowSupplier.get();
            }
            throw new NoSuchElementException();
        }
    }
}

