/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionVisitor;

@PublicEvolving
public final class SqlCallExpression
implements Expression {
    private static final String FORMAT = "[%s]";
    private final String sqlExpression;

    public SqlCallExpression(String sqlExpression) {
        this.sqlExpression = sqlExpression;
    }

    public String getSqlExpression() {
        return this.sqlExpression;
    }

    @Override
    public String asSummaryString() {
        return String.format(FORMAT, this.sqlExpression);
    }

    @Override
    public List<Expression> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public <R> R accept(ExpressionVisitor<R> visitor) {
        return visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlCallExpression that = (SqlCallExpression)o;
        return this.sqlExpression.equals(that.sqlExpression);
    }

    public int hashCode() {
        return Objects.hash(this.sqlExpression);
    }

    public String toString() {
        return this.asSummaryString();
    }
}

