/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions;

import java.io.File;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.externalresource.ExternalResourceInfo;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.apache.flink.table.api.TableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicEvolving
public class FunctionContext {
    private static final Logger LOG = LoggerFactory.getLogger(FunctionContext.class);
    private static final UnregisteredMetricsGroup defaultMetricsGroup = new UnregisteredMetricsGroup();
    @Nullable
    private final RuntimeContext context;
    @Nullable
    private final ClassLoader userClassLoader;
    @Nullable
    private final Map<String, String> jobParameters;

    public FunctionContext(@Nullable RuntimeContext context, @Nullable ClassLoader userClassLoader, @Nullable Configuration jobParameters) {
        this.context = context;
        this.userClassLoader = userClassLoader;
        this.jobParameters = jobParameters != null ? jobParameters.toMap() : null;
    }

    public FunctionContext(RuntimeContext context) {
        this(context, null, null);
    }

    public MetricGroup getMetricGroup() {
        if (this.context == null) {
            LOG.warn("Calls to FunctionContext.getMetricGroup will have no effect at the current location.");
            return defaultMetricsGroup;
        }
        return this.context.getMetricGroup();
    }

    public File getCachedFile(String name) {
        if (this.context == null) {
            throw new TableException("Calls to FunctionContext.getCachedFile are not available at the current location.");
        }
        return this.context.getDistributedCache().getFile(name);
    }

    public String getJobParameter(String key, String defaultValue) {
        if (this.context == null && this.jobParameters == null) {
            throw new TableException("Calls to FunctionContext.getJobParameter are not available at the current location.");
        }
        if (this.context == null) {
            return this.jobParameters.getOrDefault(key, defaultValue);
        }
        return this.context.getGlobalJobParameters().getOrDefault(key, defaultValue);
    }

    public Set<ExternalResourceInfo> getExternalResourceInfos(String resourceName) {
        if (this.context == null) {
            throw new TableException("Calls to FunctionContext.getExternalResourceInfos are not available at the current location.");
        }
        return this.context.getExternalResourceInfos(resourceName);
    }

    public ClassLoader getUserCodeClassLoader() {
        if (this.context == null && this.userClassLoader == null) {
            throw new TableException("Calls to FunctionContext.getUserCodeClassLoader are not available at the current location.");
        }
        if (this.context == null) {
            return this.userClassLoader;
        }
        return this.context.getUserCodeClassLoader();
    }
}

