/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentTypeStrategy;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.Signature;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeCasts;

@Internal
class ArrayElementArgumentTypeStrategy
implements ArgumentTypeStrategy {
    ArrayElementArgumentTypeStrategy() {
    }

    @Override
    public Optional<DataType> inferArgumentType(CallContext callContext, int argumentPos, boolean throwOnFailure) {
        ArrayType haystackType = (ArrayType)callContext.getArgumentDataTypes().get(0).getLogicalType();
        LogicalType needleType = callContext.getArgumentDataTypes().get(argumentPos).getLogicalType();
        LogicalType haystackElementType = haystackType.getElementType();
        if (!haystackElementType.isNullable() && needleType.isNullable()) {
            haystackElementType = haystackElementType.copy(true);
        }
        if (LogicalTypeCasts.supportsImplicitCast(needleType, haystackElementType)) {
            return Optional.of(DataTypes.of(haystackElementType));
        }
        return Optional.empty();
    }

    @Override
    public Signature.Argument getExpectedArgument(FunctionDefinition functionDefinition, int argumentPos) {
        return Signature.Argument.of("<ARRAY ELEMENT>");
    }
}

