/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.List;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.table.types.utils.DataTypeUtils;

@Internal
class GetTypeStrategy
implements TypeStrategy {
    GetTypeStrategy() {
    }

    @Override
    public Optional<DataType> inferType(CallContext callContext) {
        Optional<Integer> fieldIndex;
        List<DataType> argumentDataTypes = callContext.getArgumentDataTypes();
        DataType rowDataType = argumentDataTypes.get(0);
        Optional<Object> result = Optional.empty();
        Optional<String> fieldName = callContext.getArgumentValue(1, String.class);
        if (fieldName.isPresent()) {
            result = DataTypeUtils.getField(rowDataType, fieldName.get());
        }
        if ((fieldIndex = callContext.getArgumentValue(1, Integer.class)).isPresent()) {
            result = DataTypeUtils.getField(rowDataType, fieldIndex.get());
        }
        return result.map(type -> {
            if (rowDataType.getLogicalType().isNullable()) {
                return (DataType)type.nullable();
            }
            return type;
        });
    }
}

