/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.List;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.JsonQueryOnEmptyOrError;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentTypeStrategy;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.Signature;
import org.apache.flink.table.types.inference.strategies.SymbolArgumentTypeStrategy;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;

@Internal
public class JsonQueryOnErrorEmptyArgumentTypeStrategy
implements ArgumentTypeStrategy {
    private final SymbolArgumentTypeStrategy<JsonQueryOnEmptyOrError> symbolStrategy = new SymbolArgumentTypeStrategy<JsonQueryOnEmptyOrError>(JsonQueryOnEmptyOrError.class);

    @Override
    public Optional<DataType> inferArgumentType(CallContext callContext, int argumentPos, boolean throwOnFailure) {
        List<DataType> actualDataTypes = callContext.getArgumentDataTypes();
        Optional<DataType> symbolType = this.symbolStrategy.inferArgumentType(callContext, argumentPos, throwOnFailure);
        if (!symbolType.isPresent()) {
            return Optional.empty();
        }
        LogicalType returnType = actualDataTypes.get(2).getLogicalType();
        if (returnType.is(LogicalTypeRoot.ARRAY) && callContext.getArgumentValue(argumentPos, JsonQueryOnEmptyOrError.class).get() == JsonQueryOnEmptyOrError.EMPTY_OBJECT) {
            String behaviour = argumentPos == 5 ? "on error" : "on empty";
            return callContext.fail(throwOnFailure, String.format("Illegal %s behavior 'EMPTY OBJECT' for return type: %s", behaviour, returnType.asSummaryString()), actualDataTypes.toArray());
        }
        return symbolType;
    }

    @Override
    public Signature.Argument getExpectedArgument(FunctionDefinition functionDefinition, int argumentPos) {
        return this.symbolStrategy.getExpectedArgument(functionDefinition, argumentPos);
    }
}

