/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.base.sink.writer.strategy;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.base.sink.writer.strategy.ScalingStrategy;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class AIMDScalingStrategy
implements ScalingStrategy<Integer> {
    private final int increaseRate;
    private final double decreaseFactor;
    private final int rateThreshold;

    public AIMDScalingStrategy(int increaseRate, double decreaseFactor, int rateThreshold) {
        Preconditions.checkArgument((increaseRate > 0 ? 1 : 0) != 0, (Object)"increaseRate must be positive integer.");
        Preconditions.checkArgument((decreaseFactor < 1.0 && decreaseFactor > 0.0 ? 1 : 0) != 0, (Object)"decreaseFactor must be strictly between 0.0 and 1.0.");
        Preconditions.checkArgument((rateThreshold > 0 ? 1 : 0) != 0, (Object)"rateThreshold must be a positive integer.");
        this.increaseRate = increaseRate;
        this.decreaseFactor = decreaseFactor;
        this.rateThreshold = rateThreshold;
    }

    @Override
    public Integer scaleUp(Integer currentRate) {
        return Math.min(currentRate + this.increaseRate, this.rateThreshold);
    }

    @Override
    public Integer scaleDown(Integer currentRate) {
        return Math.max(1, (int)Math.round((double)currentRate.intValue() * this.decreaseFactor));
    }

    @PublicEvolving
    public static AIMDScalingStrategyBuilder builder(int rateThreshold) {
        return new AIMDScalingStrategyBuilder(rateThreshold);
    }

    @PublicEvolving
    public static class AIMDScalingStrategyBuilder {
        private final int rateThreshold;
        private int increaseRate = 10;
        private double decreaseFactor = 0.5;

        public AIMDScalingStrategyBuilder(int rateThreshold) {
            this.rateThreshold = rateThreshold;
        }

        public AIMDScalingStrategyBuilder setIncreaseRate(int increaseRate) {
            this.increaseRate = increaseRate;
            return this;
        }

        public AIMDScalingStrategyBuilder setDecreaseFactor(double decreaseFactor) {
            this.decreaseFactor = decreaseFactor;
            return this;
        }

        public AIMDScalingStrategy build() {
            return new AIMDScalingStrategy(this.increaseRate, this.decreaseFactor, this.rateThreshold);
        }
    }
}

