/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.aggregate.asyncwindow.processors;

import java.io.Serializable;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.api.common.state.v2.StateFuture;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.state.StateFutureUtils;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.GeneratedNamespaceAggsHandleFunction;
import org.apache.flink.table.runtime.operators.aggregate.asyncwindow.buffers.AsyncStateWindowBuffer;
import org.apache.flink.table.runtime.operators.aggregate.asyncwindow.processors.AbstractAsyncStateSliceWindowAggProcessor;
import org.apache.flink.table.runtime.operators.window.async.AsyncMergeCallback;
import org.apache.flink.table.runtime.operators.window.async.tvf.common.AsyncStateWindowProcessor;
import org.apache.flink.table.runtime.operators.window.tvf.slicing.SliceSharedAssigner;

public final class AsyncStateSliceSharedWindowAggProcessor
extends AbstractAsyncStateSliceWindowAggProcessor
implements AsyncMergeCallback<Long, Iterable<Long>> {
    private static final long serialVersionUID = 1L;
    private final SliceSharedAssigner sliceSharedAssigner;

    public AsyncStateSliceSharedWindowAggProcessor(GeneratedNamespaceAggsHandleFunction<Long> genAggsHandler, AsyncStateWindowBuffer.Factory bufferFactory, SliceSharedAssigner sliceAssigner, TypeSerializer<RowData> accSerializer, int indexOfCountStar, ZoneId shiftTimeZone) {
        super(genAggsHandler, bufferFactory, sliceAssigner, accSerializer, indexOfCountStar, shiftTimeZone);
        this.sliceSharedAssigner = sliceAssigner;
    }

    @Override
    public StateFuture<Void> fireWindow(long timerTimestamp, Long windowEnd) throws Exception {
        return this.sliceSharedAssigner.asyncMergeSlices(windowEnd, this).thenAccept(accAndAggResult -> {
            Optional<Long> nextWindowEndOptional;
            if (!this.emptyChecker.apply((RowData)accAndAggResult.f0).booleanValue()) {
                this.collect(((AsyncStateWindowProcessor.AsyncStateContext)this.ctx).getAsyncKeyContext().getCurrentKey(), (RowData)accAndAggResult.f1);
            }
            if ((nextWindowEndOptional = this.sliceSharedAssigner.nextTriggerWindow(windowEnd, (RowData)accAndAggResult.f0, this.emptyChecker)).isPresent()) {
                long nextWindowEnd = nextWindowEndOptional.get();
                if (this.sliceSharedAssigner.isEventTime()) {
                    this.windowTimerService.registerEventTimeWindowTimer(nextWindowEnd);
                } else {
                    this.windowTimerService.registerProcessingTimeWindowTimer(nextWindowEnd);
                }
            }
        });
    }

    @Override
    public StateFuture<Tuple2<RowData, RowData>> asyncMerge(@Nullable Long mergeResult, Iterable<Long> toBeMerged, Long resultNamespace) throws Exception {
        StateFuture accOfMergeResultFuture = mergeResult == null ? StateFutureUtils.completedFuture((Object)this.aggregator.createAccumulators()) : this.windowState.asyncValue(mergeResult).thenApply(stateAcc -> {
            if (stateAcc == null) {
                return this.aggregator.createAccumulators();
            }
            return stateAcc;
        });
        StateFuture<Collection<Tuple2<Long, RowData>>> allAccOfSlicesToBeMergedFuture = this.collectAccOfSlicesToBeMerged(toBeMerged);
        return accOfMergeResultFuture.thenCombine(allAccOfSlicesToBeMergedFuture, (accOfMergeResult, allAccOfSlicesToBeMerged) -> {
            this.aggregator.setAccumulators(mergeResult, (RowData)accOfMergeResult);
            for (Tuple2 sliceAndAcc : allAccOfSlicesToBeMerged) {
                RowData sliceAcc = (RowData)sliceAndAcc.f1;
                if (sliceAcc == null) continue;
                this.aggregator.merge((Long)sliceAndAcc.f0, sliceAcc);
            }
            return Tuple2.of((Object)this.aggregator.getAccumulators(), (Object)this.aggregator.getValue(resultNamespace));
        }).thenCompose(accAndAggResult -> {
            if (mergeResult != null) {
                return this.windowState.asyncUpdate(mergeResult, (RowData)accAndAggResult.f0).thenApply(VOID -> accAndAggResult);
            }
            return StateFutureUtils.completedFuture((Object)accAndAggResult);
        });
    }

    private StateFuture<Collection<Tuple2<Long, RowData>>> collectAccOfSlicesToBeMerged(Iterable<Long> slicesToBeMerged) throws Exception {
        ArrayList<StateFuture> futures = new ArrayList<StateFuture>();
        for (Long slice : slicesToBeMerged) {
            futures.add(this.windowState.asyncValue(slice).thenApply(acc -> Tuple2.of((Object)slice, (Object)acc)));
        }
        return StateFutureUtils.combineAll(futures);
    }

    @Override
    protected StateFuture<Long> sliceStateMergeTarget(long sliceToMerge) throws Exception {
        SliceMergeTargetHelper mergeHelper = new SliceMergeTargetHelper();
        return this.sliceSharedAssigner.asyncMergeSlices(sliceToMerge, mergeHelper).thenApply(VOID -> {
            if (mergeHelper.getMergeTarget() != null) {
                return mergeHelper.getMergeTarget();
            }
            return sliceToMerge;
        });
    }

    private static final class SliceMergeTargetHelper
    implements AsyncMergeCallback<Long, Iterable<Long>>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final StateFuture<Tuple2<RowData, RowData>> REUSABLE_FUTURE_RESULT = StateFutureUtils.completedFuture(null);
        private Long mergeTarget = null;

        private SliceMergeTargetHelper() {
        }

        @Override
        public StateFuture<Tuple2<RowData, RowData>> asyncMerge(@Nullable Long mergeResult, Iterable<Long> toBeMerged, Long resultNamespace) {
            this.mergeTarget = mergeResult;
            return REUSABLE_FUTURE_RESULT;
        }

        public Long getMergeTarget() {
            return this.mergeTarget;
        }
    }
}

