/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.search;

import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.runtime.collector.ListenableCollector;
import org.apache.flink.table.runtime.generated.GeneratedCollector;
import org.apache.flink.table.runtime.generated.GeneratedFunction;
import org.apache.flink.table.runtime.operators.AbstractFunctionRunner;
import org.apache.flink.util.Collector;

public class VectorSearchRunner
extends AbstractFunctionRunner {
    private static final long serialVersionUID = 1L;
    private final GeneratedCollector<ListenableCollector<RowData>> generatedCollector;
    private final boolean isLeftOuterJoin;
    private final int searchTableFieldCount;
    private transient ListenableCollector<RowData> collector;
    private transient JoinedRowData outRow;
    private transient GenericRowData nullRow;

    public VectorSearchRunner(GeneratedFunction<FlatMapFunction<RowData, RowData>> generatedFetcher, GeneratedCollector<ListenableCollector<RowData>> generatedCollector, boolean isLeftOuterJoin, int searchTableFieldCount) {
        super(generatedFetcher);
        this.generatedCollector = generatedCollector;
        this.isLeftOuterJoin = isLeftOuterJoin;
        this.searchTableFieldCount = searchTableFieldCount;
    }

    @Override
    public void open(OpenContext openContext) throws Exception {
        super.open(openContext);
        this.collector = (ListenableCollector)((Object)this.generatedCollector.newInstance(this.getRuntimeContext().getUserCodeClassLoader()));
        FunctionUtils.setFunctionRuntimeContext(this.collector, (RuntimeContext)this.getRuntimeContext());
        FunctionUtils.openFunction(this.collector, (OpenContext)openContext);
        this.nullRow = new GenericRowData(this.searchTableFieldCount);
        this.outRow = new JoinedRowData();
    }

    public void processElement(RowData in, ProcessFunction.Context ctx, Collector<RowData> out) throws Exception {
        this.prepareCollector(in, out);
        this.doFetch(in);
        this.padNullForLeftJoin(in, out);
    }

    public void prepareCollector(RowData in, Collector<RowData> out) {
        this.collector.setCollector(out);
        this.collector.setInput(in);
        this.collector.reset();
    }

    public void doFetch(RowData in) throws Exception {
        this.fetcher.flatMap((Object)in, this.collector);
    }

    public void padNullForLeftJoin(RowData in, Collector<RowData> out) {
        if (this.isLeftOuterJoin && !this.collector.isCollected()) {
            this.outRow.replace(in, (RowData)this.nullRow);
            this.outRow.setRowKind(in.getRowKind());
            out.collect((Object)this.outRow);
        }
    }

    @Override
    public void close() throws Exception {
        super.close();
        if (this.collector != null) {
            FunctionUtils.closeFunction(this.collector);
        }
    }
}

