/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFamily;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlDynamicParam;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.type.FlinkSqlTypeMappingRule;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.util.Static;
import org.apache.flink.calcite.shaded.com.google.common.base.Preconditions;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableSetMultimap;
import org.apache.flink.calcite.shaded.com.google.common.collect.SetMultimap;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeCasts;

public class SqlCastFunction
extends SqlFunction {
    private final SetMultimap<SqlTypeFamily, SqlTypeFamily> nonMonotonicCasts = ((ImmutableSetMultimap.Builder)((ImmutableSetMultimap.Builder)((ImmutableSetMultimap.Builder)((ImmutableSetMultimap.Builder)((ImmutableSetMultimap.Builder)((ImmutableSetMultimap.Builder)((ImmutableSetMultimap.Builder)((ImmutableSetMultimap.Builder)((ImmutableSetMultimap.Builder)((ImmutableSetMultimap.Builder)((ImmutableSetMultimap.Builder)((ImmutableSetMultimap.Builder)ImmutableSetMultimap.builder().put(SqlTypeFamily.EXACT_NUMERIC, SqlTypeFamily.CHARACTER)).put(SqlTypeFamily.NUMERIC, SqlTypeFamily.CHARACTER)).put(SqlTypeFamily.APPROXIMATE_NUMERIC, SqlTypeFamily.CHARACTER)).put(SqlTypeFamily.DATETIME_INTERVAL, SqlTypeFamily.CHARACTER)).put(SqlTypeFamily.CHARACTER, SqlTypeFamily.EXACT_NUMERIC)).put(SqlTypeFamily.CHARACTER, SqlTypeFamily.NUMERIC)).put(SqlTypeFamily.CHARACTER, SqlTypeFamily.APPROXIMATE_NUMERIC)).put(SqlTypeFamily.CHARACTER, SqlTypeFamily.DATETIME_INTERVAL)).put(SqlTypeFamily.DATETIME, SqlTypeFamily.TIME)).put(SqlTypeFamily.TIMESTAMP, SqlTypeFamily.TIME)).put(SqlTypeFamily.TIME, SqlTypeFamily.DATETIME)).put(SqlTypeFamily.TIME, SqlTypeFamily.TIMESTAMP)).build();

    public SqlCastFunction() {
        this(SqlKind.CAST.toString(), SqlKind.CAST);
    }

    public SqlCastFunction(String name, SqlKind kind) {
        super(name, kind, SqlCastFunction.returnTypeInference(kind == SqlKind.SAFE_CAST), InferTypes.FIRST_KNOWN, null, SqlFunctionCategory.SYSTEM);
        Preconditions.checkArgument(kind == SqlKind.CAST || kind == SqlKind.SAFE_CAST, (Object)kind);
    }

    static SqlReturnTypeInference returnTypeInference(boolean safe) {
        return opBinding -> {
            SqlCallBinding callBinding;
            SqlNode operand0;
            assert (opBinding.getOperandCount() == 2);
            RelDataType ret = SqlCastFunction.deriveType(opBinding.getTypeFactory(), opBinding.getOperandType(0), opBinding.getOperandType(1), safe);
            if (opBinding instanceof SqlCallBinding && (SqlUtil.isNullLiteral(operand0 = (callBinding = (SqlCallBinding)opBinding).operand(0), false) || operand0 instanceof SqlDynamicParam)) {
                callBinding.getValidator().setValidatedNodeType(operand0, ret);
            }
            return ret;
        };
    }

    public static RelDataType deriveType(RelDataTypeFactory typeFactory, RelDataType expressionType, RelDataType targetType, boolean safe) {
        return typeFactory.createTypeWithNullability(targetType, expressionType.isNullable() || safe);
    }

    private static RelDataType createTypeWithNullabilityFromExpr(RelDataTypeFactory typeFactory, RelDataType expressionType, RelDataType targetType, boolean safe) {
        boolean isNullable;
        boolean bl = isNullable = expressionType.isNullable() || safe;
        if (SqlTypeUtil.isCollection(expressionType)) {
            RelDataType expressionElementType = expressionType.getComponentType();
            RelDataType targetElementType = targetType.getComponentType();
            Objects.requireNonNull(expressionElementType, () -> "componentType of " + String.valueOf(expressionType));
            Objects.requireNonNull(targetElementType, () -> "componentType of " + String.valueOf(targetType));
            RelDataType newElementType = SqlCastFunction.createTypeWithNullabilityFromExpr(typeFactory, expressionElementType, targetElementType, safe);
            return SqlTypeUtil.isArray(targetType) ? SqlTypeUtil.createArrayType(typeFactory, newElementType, isNullable) : SqlTypeUtil.createMultisetType(typeFactory, newElementType, isNullable);
        }
        if (SqlTypeUtil.isRow(expressionType)) {
            int fieldCount = expressionType.getFieldCount();
            ArrayList<RelDataType> typeList = new ArrayList<RelDataType>(fieldCount);
            for (int i = 0; i < fieldCount; ++i) {
                RelDataType expressionElementType = expressionType.getFieldList().get(i).getType();
                RelDataType targetElementType = targetType.getFieldList().get(i).getType();
                typeList.add(SqlCastFunction.createTypeWithNullabilityFromExpr(typeFactory, expressionElementType, targetElementType, safe));
            }
            return typeFactory.createTypeWithNullability(typeFactory.createStructType(typeList, targetType.getFieldNames()), isNullable);
        }
        if (SqlTypeUtil.isMap(expressionType)) {
            RelDataType expressionKeyType = Objects.requireNonNull(expressionType.getKeyType(), () -> "keyType of " + String.valueOf(expressionType));
            RelDataType expressionValueType = Objects.requireNonNull(expressionType.getValueType(), () -> "valueType of " + String.valueOf(expressionType));
            RelDataType targetKeyType = Objects.requireNonNull(targetType.getKeyType(), () -> "keyType of " + String.valueOf(targetType));
            RelDataType targetValueType = Objects.requireNonNull(targetType.getValueType(), () -> "valueType of " + String.valueOf(targetType));
            RelDataType keyType = SqlCastFunction.createTypeWithNullabilityFromExpr(typeFactory, expressionKeyType, targetKeyType, safe);
            RelDataType valueType = SqlCastFunction.createTypeWithNullabilityFromExpr(typeFactory, expressionValueType, targetValueType, safe);
            SqlTypeUtil.createMapType(typeFactory, keyType, valueType, isNullable);
        }
        return typeFactory.createTypeWithNullability(targetType, isNullable);
    }

    @Override
    public String getSignatureTemplate(int operandsCount) {
        assert (operandsCount == 2);
        return "{0}({1} AS {2})";
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of(2);
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        SqlNode left = callBinding.operand(0);
        SqlNode right = callBinding.operand(1);
        if (SqlUtil.isNullLiteral(left, false) || left instanceof SqlDynamicParam) {
            return true;
        }
        RelDataType validatedNodeType = callBinding.getValidator().getValidatedNodeType(left);
        RelDataType returnType = SqlTypeUtil.deriveType(callBinding, right);
        if (!this.canCastFrom(returnType, validatedNodeType)) {
            if (throwOnFailure) {
                throw callBinding.newError(Static.RESOURCE.cannotCastValue(validatedNodeType.toString(), returnType.toString()));
            }
            return false;
        }
        if (SqlTypeUtil.areCharacterSetsMismatched(validatedNodeType, returnType)) {
            if (throwOnFailure) {
                throw callBinding.newError(Static.RESOURCE.cannotCastValue(validatedNodeType.getFullTypeString(), returnType.getFullTypeString()));
            }
            return false;
        }
        return true;
    }

    private boolean canCastFrom(RelDataType toType, RelDataType fromType) {
        SqlTypeName fromTypeName = fromType.getSqlTypeName();
        if (toType.getSqlTypeName() == SqlTypeName.VARIANT) {
            return false;
        }
        switch (fromTypeName) {
            case ARRAY: 
            case MAP: 
            case MULTISET: 
            case STRUCTURED: 
            case ROW: 
            case VARIANT: 
            case OTHER: {
                return LogicalTypeCasts.supportsExplicitCast((LogicalType)FlinkTypeFactory.toLogicalType(fromType), (LogicalType)FlinkTypeFactory.toLogicalType(toType));
            }
        }
        return SqlTypeUtil.canCastFrom(toType, fromType, FlinkSqlTypeMappingRule.instance());
    }

    @Override
    public SqlSyntax getSyntax() {
        return SqlSyntax.SPECIAL;
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        assert (call.operandCount() == 2);
        SqlWriter.Frame frame = writer.startFunCall(this.getName());
        ((SqlNode)call.operand(0)).unparse(writer, 0, 0);
        writer.sep("AS");
        if (call.operand(1) instanceof SqlIntervalQualifier) {
            writer.sep("INTERVAL");
        }
        ((SqlNode)call.operand(1)).unparse(writer, 0, 0);
        writer.endFunCall(frame);
    }

    @Override
    public SqlMonotonicity getMonotonicity(SqlOperatorBinding call) {
        Collator castToCollator;
        RelDataType castFromType = call.getOperandType(0);
        RelDataTypeFamily castFromFamily = castFromType.getFamily();
        Collator castFromCollator = castFromType.getCollation() == null ? null : castFromType.getCollation().getCollator();
        RelDataType castToType = call.getOperandType(1);
        RelDataTypeFamily castToFamily = castToType.getFamily();
        Collator collator = castToCollator = castToType.getCollation() == null ? null : castToType.getCollation().getCollator();
        if (!Objects.equals(castFromCollator, castToCollator)) {
            return SqlMonotonicity.NOT_MONOTONIC;
        }
        if (castFromFamily instanceof SqlTypeFamily && castToFamily instanceof SqlTypeFamily && this.nonMonotonicCasts.containsEntry(castFromFamily, castToFamily)) {
            return SqlMonotonicity.NOT_MONOTONIC;
        }
        return call.getOperandMonotonicity(0);
    }
}

