/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.type.NonNullableAccessors;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.SameOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.util.Static;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;

public class ArrayInsertOperandTypeChecker
extends SameOperandTypeChecker {
    public ArrayInsertOperandTypeChecker() {
        super(3);
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        for (SqlNode node : callBinding.operands()) {
            if (!SqlUtil.isNullLiteral(node, false)) continue;
            if (throwOnFailure) {
                throw callBinding.getValidator().newValidationError(node, Static.RESOURCE.argumentMustNotBeNull(callBinding.getOperator().getName()));
            }
            return false;
        }
        SqlNode op0 = callBinding.operand(0);
        if (!OperandTypes.ARRAY.checkSingleOperandType(callBinding, op0, 0, throwOnFailure)) {
            return false;
        }
        SqlNode op1 = callBinding.operand(1);
        RelDataType op1Type = SqlTypeUtil.deriveType(callBinding, op1);
        SqlTypeName op1TypeName = op1Type.getSqlTypeName();
        if (op1TypeName != SqlTypeName.INTEGER) {
            if (throwOnFailure) {
                throw callBinding.newError(Static.RESOURCE.typeNotComparable(op1TypeName.getName(), SqlTypeName.INTEGER.getName()));
            }
            return false;
        }
        RelDataType op0ComponentType = NonNullableAccessors.getComponentTypeOrThrow(SqlTypeUtil.deriveType(callBinding, op0));
        SqlNode op2 = callBinding.operand(2);
        RelDataType op2Type = SqlTypeUtil.deriveType(callBinding, op2);
        RelDataType biggest = callBinding.getTypeFactory().leastRestrictive(ImmutableList.of(op0ComponentType, op2Type));
        if (biggest == null) {
            if (throwOnFailure) {
                throw callBinding.newError(Static.RESOURCE.typeNotComparable(op0ComponentType.getSqlTypeName().getName(), op2Type.getSqlTypeName().getName()));
            }
            return false;
        }
        return true;
    }
}

