/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions.converter;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.flink.table.catalog.ContextResolvedFunction;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.functions.BuiltInFunctionDefinition;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.planner.expressions.converter.CallExpressionConvertRule;
import org.apache.flink.table.planner.functions.bridging.BridgingSqlFunction;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.inference.TypeStrategies;

public class FunctionDefinitionConvertRule
implements CallExpressionConvertRule {
    @Override
    public Optional<RexNode> convert(CallExpression call, CallExpressionConvertRule.ConvertContext context) {
        BuiltInFunctionDefinition builtInFunction;
        FunctionDefinition definition = call.getFunctionDefinition();
        if (definition instanceof BuiltInFunctionDefinition && !(builtInFunction = (BuiltInFunctionDefinition)definition).hasRuntimeImplementation()) {
            return Optional.empty();
        }
        TypeInference typeInference = definition.getTypeInference(context.getDataTypeFactory());
        if (typeInference.getOutputTypeStrategy() == TypeStrategies.MISSING) {
            return Optional.empty();
        }
        switch (definition.getKind()) {
            case SCALAR: 
            case ASYNC_SCALAR: 
            case TABLE: 
            case ASYNC_TABLE: {
                List args = call.getChildren().stream().map(context::toRexNode).collect(Collectors.toList());
                BridgingSqlFunction sqlFunction = BridgingSqlFunction.of(context.getDataTypeFactory(), context.getTypeFactory(), context.getRexFactory(), SqlKind.OTHER_FUNCTION, ContextResolvedFunction.fromCallExpression((CallExpression)call), typeInference);
                return Optional.of(context.getRelBuilder().call((SqlOperator)sqlFunction, args));
            }
        }
        return Optional.empty();
    }
}

