/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations.converters.table;

import java.util.List;
import org.apache.flink.sql.parser.ddl.SqlAlterTableRenameColumn;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.TableChange;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.planner.operations.converters.SchemaReferencesManager;
import org.apache.flink.table.planner.operations.converters.SqlNodeConverter;
import org.apache.flink.table.planner.operations.converters.table.AbstractAlterTableConverter;

public class SqlAlterTableRenameColumnConverter
extends AbstractAlterTableConverter<SqlAlterTableRenameColumn> {
    @Override
    protected Operation convertToOperation(SqlAlterTableRenameColumn renameColumn, ResolvedCatalogTable oldTable, SqlNodeConverter.ConvertContext context) {
        String oldColumnName = SqlAlterTableRenameColumnConverter.getColumnName(renameColumn.getOldColumnIdentifier());
        String newColumnName = SqlAlterTableRenameColumnConverter.getColumnName(renameColumn.getNewColumnIdentifier());
        SchemaReferencesManager.create(oldTable).checkReferences(oldColumnName, () -> "Failed to execute ALTER TABLE statement.\n");
        if (oldTable.getResolvedSchema().getColumn(newColumnName).isPresent()) {
            throw new ValidationException(String.format("%sThe column `%s` already existed in table schema.", "Failed to execute ALTER TABLE statement.\n", newColumnName));
        }
        Schema.Builder schemaBuilder = Schema.newBuilder();
        SchemaReferencesManager.buildUpdatedColumn(schemaBuilder, oldTable, (builder, column) -> {
            if (column.getName().equals(oldColumnName)) {
                this.buildNewColumnFromOldColumn((Schema.Builder)builder, (Schema.UnresolvedColumn)column, newColumnName);
            } else {
                builder.fromColumns(List.of(column));
            }
        });
        SchemaReferencesManager.buildUpdatedPrimaryKey(schemaBuilder, oldTable, pk -> pk.equals(oldColumnName) ? newColumnName : pk);
        SchemaReferencesManager.buildUpdatedWatermark(schemaBuilder, oldTable);
        return this.buildAlterTableChangeOperation(renameColumn, List.of(TableChange.modifyColumnName((Column)((Column)oldTable.getResolvedSchema().getColumn(oldColumnName).orElseThrow(() -> new TableException("The value should never be empty."))), (String)newColumnName)), schemaBuilder.build(), oldTable, context.getCatalogManager());
    }

    private void buildNewColumnFromOldColumn(Schema.Builder builder, Schema.UnresolvedColumn oldColumn, String columnName) {
        if (oldColumn instanceof Schema.UnresolvedComputedColumn) {
            builder.columnByExpression(columnName, ((Schema.UnresolvedComputedColumn)oldColumn).getExpression());
        } else if (oldColumn instanceof Schema.UnresolvedPhysicalColumn) {
            builder.column(columnName, ((Schema.UnresolvedPhysicalColumn)oldColumn).getDataType());
        } else if (oldColumn instanceof Schema.UnresolvedMetadataColumn) {
            Schema.UnresolvedMetadataColumn metadataColumn = (Schema.UnresolvedMetadataColumn)oldColumn;
            builder.columnByMetadata(columnName, metadataColumn.getDataType(), metadataColumn.getMetadataKey(), metadataColumn.isVirtual());
        }
        oldColumn.getComment().ifPresent(arg_0 -> ((Schema.Builder)builder).withComment(arg_0));
    }
}

