/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonGetter;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.TimeUtils;

@Internal
@JsonIgnoreProperties(ignoreUnknown=true)
public class StateMetadata {
    public static final String FIELD_NAME_STATE_INDEX = "index";
    public static final String FIELD_NAME_STATE_TTL = "ttl";
    public static final String FIELD_NAME_STATE_NAME = "name";
    @JsonProperty(value="index", index=0)
    private final int stateIndex;
    @JsonProperty(value="ttl", index=1)
    private final Duration stateTtl;
    @JsonProperty(value="name", index=2)
    private final String stateName;

    @JsonCreator
    public StateMetadata(@JsonProperty(value="index") int stateIndex, @JsonProperty(value="ttl") String stateTtl, @JsonProperty(value="name") String stateName) {
        this(stateIndex, TimeUtils.parseDuration((String)((String)Preconditions.checkNotNull((Object)stateTtl, (String)"state ttl should not be null"))), stateName);
    }

    public StateMetadata(int stateIndex, Duration stateTtl, String stateName) {
        Preconditions.checkArgument((stateIndex >= 0 ? 1 : 0) != 0, (Object)"state index should start from 0");
        this.stateIndex = stateIndex;
        this.stateTtl = (Duration)Preconditions.checkNotNull((Object)stateTtl, (String)"state ttl should not be null");
        this.stateName = (String)Preconditions.checkNotNull((Object)stateName, (String)"state name should not be null");
    }

    public int getStateIndex() {
        return this.stateIndex;
    }

    @JsonGetter(value="ttl")
    public String getStateTtl() {
        return TimeUtils.formatWithHighestUnit((Duration)this.stateTtl);
    }

    public static List<StateMetadata> getOneInputOperatorDefaultMeta(ReadableConfig tableConfig, String stateName) {
        return StateMetadata.getOneInputOperatorDefaultMeta(null, tableConfig, stateName);
    }

    public static List<StateMetadata> getOneInputOperatorDefaultMeta(@Nullable Long stateTtlFromHint, ReadableConfig tableConfig, String stateName) {
        return Collections.singletonList(new StateMetadata(0, stateTtlFromHint == null ? (Duration)tableConfig.get(ExecutionConfigOptions.IDLE_STATE_RETENTION) : Duration.ofMillis(stateTtlFromHint), stateName));
    }

    public static List<StateMetadata> getMultiInputOperatorDefaultMeta(Map<Integer, Long> stateTtlFromHint, ReadableConfig tableConfig, String ... stateNameList) {
        Duration ttlFromTableConf = (Duration)tableConfig.get(ExecutionConfigOptions.IDLE_STATE_RETENTION);
        ArrayList<StateMetadata> stateMetadataList = new ArrayList<StateMetadata>(stateNameList.length);
        for (int i = 0; i < stateNameList.length; ++i) {
            Duration stateTtl = stateTtlFromHint.containsKey(i) ? Duration.ofMillis(stateTtlFromHint.get(i)) : ttlFromTableConf;
            stateMetadataList.add(new StateMetadata(i, stateTtl, stateNameList[i]));
        }
        return stateMetadataList;
    }

    public static long getStateTtlForOneInputOperator(ExecNodeConfig config, @Nullable List<StateMetadata> stateMetadataList) {
        return StateMetadata.getStateTtlForMultiInputOperator(config, 1, stateMetadataList).get(0);
    }

    public static List<Long> getStateTtlForMultiInputOperator(ExecNodeConfig config, int inputNumOfOperator, @Nullable List<StateMetadata> stateMetadataList) {
        if (CollectionUtil.isNullOrEmpty(stateMetadataList)) {
            return Stream.generate(config::getStateRetentionTime).limit(inputNumOfOperator).collect(Collectors.toList());
        }
        StateMetadata.validateStateMetadata(inputNumOfOperator, stateMetadataList);
        return stateMetadataList.stream().sorted(Comparator.comparing(StateMetadata::getStateIndex)).map(metadata -> metadata.stateTtl.toMillis()).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StateMetadata)) {
            return false;
        }
        StateMetadata that = (StateMetadata)o;
        return this.stateIndex == that.stateIndex && this.stateTtl.equals(that.stateTtl) && this.stateName.equals(that.stateName);
    }

    public int hashCode() {
        return Objects.hash(this.stateIndex, this.stateTtl, this.stateName);
    }

    private static void validateStateMetadata(int inputNumOfOperator, List<StateMetadata> stateMetadataList) {
        Preconditions.checkArgument((inputNumOfOperator == stateMetadataList.size() ? 1 : 0) != 0, (Object)String.format("The compiled plan contains inconsistent state metadata configuration.\nReceived %s state meta for a %sInputStreamOperator.", stateMetadataList.size(), inputNumOfOperator > 2 ? "Multiple" : (inputNumOfOperator == 2 ? "Two" : "One")));
        List normalizedIndexList = stateMetadataList.stream().map(StateMetadata::getStateIndex).sorted().distinct().collect(Collectors.toList());
        Preconditions.checkArgument((normalizedIndexList.size() == inputNumOfOperator && (Integer)normalizedIndexList.get(0) == 0 && (Integer)normalizedIndexList.get(inputNumOfOperator - 1) == inputNumOfOperator - 1 ? 1 : 0) != 0, (Object)"The compiled plan contains inconsistent state metadata configuration.\nThe state index should not contain duplicates and start from 0 (inclusive) and monotonically increase to the input size (exclusive) of the operator.");
    }
}

