/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import java.util.Collections;
import java.util.List;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.codegen.sort.ComparatorCodeGenerator;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeMetadata;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.spec.SortSpec;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.planner.utils.InternalConfigOptions;
import org.apache.flink.table.runtime.generated.GeneratedRecordComparator;
import org.apache.flink.table.runtime.operators.sort.StreamSortOperator;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

@ExecNodeMetadata(name="stream-exec-sort", version=1, producedTransformations={"sort"}, minPlanVersion=FlinkVersion.v1_18, minStateVersion=FlinkVersion.v1_18)
public class StreamExecSort
extends ExecNodeBase<RowData>
implements StreamExecNode<RowData> {
    public static final String SORT_TRANSFORMATION = "sort";
    public static final String FIELD_NAME_SORT_SPEC = "orderBy";
    @JsonProperty(value="orderBy")
    private final SortSpec sortSpec;

    public StreamExecSort(ReadableConfig tableConfig, SortSpec sortSpec, InputProperty inputProperty, RowType outputType, String description) {
        super(ExecNodeContext.newNodeId(), ExecNodeContext.newContext(StreamExecSort.class), ExecNodeContext.newPersistedConfig(StreamExecSort.class, tableConfig), Collections.singletonList(inputProperty), (LogicalType)outputType, description);
        this.sortSpec = sortSpec;
    }

    @JsonCreator
    public StreamExecSort(@JsonProperty(value="id") int id, @JsonProperty(value="type") ExecNodeContext context, @JsonProperty(value="configuration") ReadableConfig persistedConfig, @JsonProperty(value="orderBy") SortSpec sortSpec, @JsonProperty(value="inputProperties") List<InputProperty> inputProperties, @JsonProperty(value="outputType") RowType outputType, @JsonProperty(value="description") String description) {
        super(id, context, persistedConfig, inputProperties, (LogicalType)outputType, description);
        this.sortSpec = sortSpec;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        if (!config.get(InternalConfigOptions.TABLE_EXEC_NON_TEMPORAL_SORT_ENABLED).booleanValue()) {
            throw new TableException("Sort on a non-time-attribute field is not supported.");
        }
        ExecEdge inputEdge = this.getInputEdges().get(0);
        RowType inputType = (RowType)inputEdge.getOutputType();
        GeneratedRecordComparator rowComparator = ComparatorCodeGenerator.gen(config, planner.getFlinkContext().getClassLoader(), "StreamExecSortComparator", inputType, this.sortSpec);
        StreamSortOperator sortOperator = new StreamSortOperator(InternalTypeInfo.of((RowType)inputType), rowComparator);
        Transformation<?> inputTransform = inputEdge.translateToPlan(planner);
        return ExecNodeUtil.createOneInputTransformation(inputTransform, this.createTransformationMeta(SORT_TRANSFORMATION, config), sortOperator, InternalTypeInfo.of((RowType)inputType), inputTransform.getParallelism(), false);
    }
}

