/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.sink.constraint;

import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.operators.sink.constraint.Constraint;
import org.apache.flink.table.runtime.operators.sink.constraint.EnforcerException;
import org.apache.flink.table.runtime.operators.sink.constraint.NotNullEnforcementStrategy;

@Internal
final class NotNullConstraint
implements Constraint {
    private final NotNullEnforcementStrategy enforcementStrategy;
    private final int[] notNullFieldIndices;
    private final String[] notNullFieldNames;

    NotNullConstraint(NotNullEnforcementStrategy enforcementStrategy, int[] notNullFieldIndices, String[] notNullFieldNames) {
        this.enforcementStrategy = enforcementStrategy;
        this.notNullFieldIndices = notNullFieldIndices;
        this.notNullFieldNames = notNullFieldNames;
    }

    @Override
    @Nullable
    public RowData enforce(RowData input) {
        for (int i = 0; i < this.notNullFieldIndices.length; ++i) {
            int index = this.notNullFieldIndices[i];
            if (!input.isNullAt(index)) continue;
            switch (this.enforcementStrategy) {
                case ERROR: {
                    throw new EnforcerException("Column '%s' is NOT NULL, however, a null value is being written into it. " + String.format("You can set job configuration '%s'='%s' to suppress this exception and drop such records silently.", ExecutionConfigOptions.TABLE_EXEC_SINK_NOT_NULL_ENFORCER.key(), ExecutionConfigOptions.NotNullEnforcer.DROP.name()), this.notNullFieldNames[i]);
                }
                case DROP: {
                    return null;
                }
            }
        }
        return input;
    }

    public String toString() {
        return String.format("NotNullEnforcer(fields=[%s])", String.join((CharSequence)", ", this.notNullFieldNames));
    }
}

