/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.sequencedmultisetstate.linked;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.function.Function;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.HashFunction;
import org.apache.flink.table.runtime.generated.RecordEqualiser;
import org.apache.flink.table.runtime.sequencedmultisetstate.SequencedMultiSetState;
import org.apache.flink.table.runtime.sequencedmultisetstate.SequencedMultiSetStateContext;
import org.apache.flink.table.runtime.sequencedmultisetstate.TimeSelector;
import org.apache.flink.table.runtime.sequencedmultisetstate.linked.MetaSqnInfo;
import org.apache.flink.table.runtime.sequencedmultisetstate.linked.MetaSqnInfoSerializer;
import org.apache.flink.table.runtime.sequencedmultisetstate.linked.Node;
import org.apache.flink.table.runtime.sequencedmultisetstate.linked.NodeSerializer;
import org.apache.flink.table.runtime.sequencedmultisetstate.linked.RowDataKey;
import org.apache.flink.table.runtime.sequencedmultisetstate.linked.RowDataKeySerializer;
import org.apache.flink.table.runtime.sequencedmultisetstate.linked.RowSqnInfo;
import org.apache.flink.table.runtime.sequencedmultisetstate.linked.RowSqnInfoSerializer;
import org.apache.flink.util.Preconditions;

@Internal
public class LinkedMultiSetState
implements SequencedMultiSetState<RowData> {
    private final MapState<RowDataKey, RowSqnInfo> rowToSqnState;
    private final MapState<Long, Node> sqnToNodeState;
    private final ValueState<MetaSqnInfo> highestSqnAndSizeState;
    private final RecordEqualiser keyEqualiser;
    private final HashFunction keyHashFunction;
    private final Function<RowData, RowData> keyExtractor;
    private final TimeSelector timeSelector;

    private LinkedMultiSetState(MapState<RowDataKey, RowSqnInfo> rowToSqnState, MapState<Long, Node> sqnToNodeState, ValueState<MetaSqnInfo> highestSqnAndSizeState, RecordEqualiser keyEqualiser, HashFunction keyHashFunction, Function<RowData, RowData> keyExtractor, TimeSelector timeSelector) {
        this.rowToSqnState = (MapState)Preconditions.checkNotNull(rowToSqnState);
        this.sqnToNodeState = (MapState)Preconditions.checkNotNull(sqnToNodeState);
        this.highestSqnAndSizeState = (ValueState)Preconditions.checkNotNull(highestSqnAndSizeState);
        this.keyEqualiser = (RecordEqualiser)Preconditions.checkNotNull((Object)keyEqualiser);
        this.keyHashFunction = (HashFunction)Preconditions.checkNotNull((Object)keyHashFunction);
        this.keyExtractor = keyExtractor;
        this.timeSelector = timeSelector;
    }

    public static LinkedMultiSetState create(SequencedMultiSetStateContext p, RuntimeContext ctx) {
        RecordEqualiser keyEqualiser = (RecordEqualiser)p.generatedKeyEqualiser.newInstance(ctx.getUserCodeClassLoader());
        HashFunction keyHashFunction = (HashFunction)p.generatedKeyHashFunction.newInstance(ctx.getUserCodeClassLoader());
        MapState rowToSqnState = ctx.getMapState(new MapStateDescriptor("rowToSqnState", (TypeSerializer)new RowDataKeySerializer(p.keySerializer, keyEqualiser, keyHashFunction, p.generatedKeyEqualiser, p.generatedKeyHashFunction), (TypeSerializer)new RowSqnInfoSerializer()));
        MapState sqnToNodeState = ctx.getMapState(new MapStateDescriptor("sqnToNodeState", (TypeSerializer)LongSerializer.INSTANCE, (TypeSerializer)new NodeSerializer(p.recordSerializer)));
        ValueState highestSqnState = ctx.getState(new ValueStateDescriptor("highestSqnState", (TypeSerializer)new MetaSqnInfoSerializer()));
        return new LinkedMultiSetState((MapState<RowDataKey, RowSqnInfo>)rowToSqnState, (MapState<Long, Node>)sqnToNodeState, (ValueState<MetaSqnInfo>)highestSqnState, keyEqualiser, keyHashFunction, p.keyExtractor, p.config.getTimeSelector());
    }

    @Override
    public SequencedMultiSetState.StateChangeInfo<RowData> add(RowData row, long timestamp) throws Exception {
        long newSize;
        long newSqn;
        Long oldSqn;
        boolean isNewContextKey;
        RowDataKey key = this.toKey(row);
        MetaSqnInfo highSqnAndSize = (MetaSqnInfo)this.highestSqnAndSizeState.value();
        Long highSqn = highSqnAndSize == null ? null : Long.valueOf(highSqnAndSize.highSqn);
        long oldSize = highSqnAndSize == null ? 0L : highSqnAndSize.size;
        RowSqnInfo rowSqnInfo = (RowSqnInfo)this.rowToSqnState.get((Object)key);
        Long rowSqn = rowSqnInfo == null ? null : Long.valueOf(((RowSqnInfo)this.rowToSqnState.get((Object)key)).firstSqn);
        boolean isNewRowKey = rowSqn == null;
        boolean bl = isNewContextKey = highSqn == null;
        if (isNewContextKey && isNewRowKey) {
            oldSqn = null;
            newSqn = 0L;
            newSize = 1L;
        } else if (isNewRowKey) {
            oldSqn = null;
            newSqn = highSqn + 1L;
            newSize = oldSize + 1L;
        } else {
            newSqn = rowSqn;
            oldSqn = newSqn;
            newSize = oldSize;
        }
        timestamp = this.timeSelector.getTimestamp(timestamp);
        this.sqnToNodeState.put((Object)newSqn, (Object)(isNewRowKey ? new Node(row, newSqn, highSqn, null, null, timestamp) : ((Node)this.sqnToNodeState.get((Object)oldSqn)).withRow(row, timestamp)));
        this.highestSqnAndSizeState.update((Object)MetaSqnInfo.of(newSqn, newSize));
        if (isNewRowKey) {
            this.rowToSqnState.put((Object)key, (Object)RowSqnInfo.ofSingle(newSqn));
            if (!isNewContextKey) {
                this.sqnToNodeState.put((Object)highSqn, (Object)((Node)this.sqnToNodeState.get((Object)highSqn)).withNext(newSqn));
            }
        }
        return SequencedMultiSetState.StateChangeInfo.forAddition(oldSize, newSize);
    }

    @Override
    public SequencedMultiSetState.StateChangeInfo<RowData> append(RowData row, long timestamp) throws Exception {
        Long rowSqn;
        RowDataKey key = this.toKey(row);
        MetaSqnInfo highSqnAndSize = (MetaSqnInfo)this.highestSqnAndSizeState.value();
        Long highSqn = highSqnAndSize == null ? null : Long.valueOf(highSqnAndSize.highSqn);
        long oldSize = highSqnAndSize == null ? 0L : highSqnAndSize.size;
        boolean existed = highSqn != null;
        long newSqn = existed ? highSqn + 1L : 0L;
        Node newNode = new Node(row, newSqn, highSqn, null, null, this.timeSelector.getTimestamp(timestamp));
        long newSize = oldSize + 1L;
        RowSqnInfo sqnInfo = existed ? (RowSqnInfo)this.rowToSqnState.get((Object)key) : null;
        Long l = rowSqn = sqnInfo == null ? null : Long.valueOf(sqnInfo.firstSqn);
        if (rowSqn == null) {
            this.rowToSqnState.put((Object)key, (Object)RowSqnInfo.ofSingle(newSqn));
        } else {
            this.rowToSqnState.put((Object)key, (Object)RowSqnInfo.of(rowSqn, newSqn));
            this.sqnToNodeState.put((Object)sqnInfo.lastSqn, (Object)((Node)this.sqnToNodeState.get((Object)sqnInfo.lastSqn)).withNextForRecord(newSqn));
        }
        this.highestSqnAndSizeState.update((Object)MetaSqnInfo.of(newSqn, newSize));
        this.sqnToNodeState.put((Object)newSqn, (Object)newNode);
        if (existed) {
            this.sqnToNodeState.put((Object)highSqn, (Object)((Node)this.sqnToNodeState.get((Object)highSqn)).withNext(newSqn));
        }
        return SequencedMultiSetState.StateChangeInfo.forAddition(oldSize, newSize);
    }

    @Override
    public SequencedMultiSetState.StateChangeInfo<RowData> remove(RowData row) throws Exception {
        long oldSize;
        RowDataKey key = this.toKey(row);
        RowSqnInfo sqnInfo = (RowSqnInfo)this.rowToSqnState.get((Object)key);
        Long rowSqn = sqnInfo == null ? null : Long.valueOf(sqnInfo.firstSqn);
        MetaSqnInfo highSqnStateAndSize = (MetaSqnInfo)this.highestSqnAndSizeState.value();
        long l = oldSize = highSqnStateAndSize == null ? 0L : highSqnStateAndSize.size;
        if (rowSqn == null) {
            return SequencedMultiSetState.StateChangeInfo.forRemovalNotFound(oldSize);
        }
        Node node = (Node)this.sqnToNodeState.get((Object)rowSqn);
        Node prev = this.removeNode(node, key, highSqnStateAndSize);
        if (!node.isHighestSqn()) {
            return SequencedMultiSetState.StateChangeInfo.forRemovedOther(oldSize, oldSize - 1L);
        }
        if (prev == null) {
            return SequencedMultiSetState.StateChangeInfo.forAllRemoved(oldSize, oldSize - 1L, row);
        }
        return SequencedMultiSetState.StateChangeInfo.forRemovedLastAdded(oldSize, oldSize - 1L, prev.row);
    }

    @Override
    public void clear() {
        this.clearCache();
        this.sqnToNodeState.clear();
        this.highestSqnAndSizeState.clear();
        this.rowToSqnState.clear();
    }

    @Override
    public void loadCache() {
    }

    @Override
    public void clearCache() {
    }

    private Node removeNode(Node node, RowDataKey key, MetaSqnInfo highSqnStateAndSize) throws Exception {
        if (node.isLowestSqn() && node.isHighestSqn()) {
            this.clear();
            return null;
        }
        this.sqnToNodeState.remove((Object)node.getSqn());
        this.highestSqnAndSizeState.update((Object)MetaSqnInfo.of(node.isHighestSqn() ? node.prevSqn : highSqnStateAndSize.highSqn, highSqnStateAndSize.size - 1L));
        if (node.isLastForRecord()) {
            this.rowToSqnState.remove((Object)key);
        } else {
            this.rowToSqnState.put((Object)key, (Object)((RowSqnInfo)this.rowToSqnState.get((Object)key)).withFirstSqn(node.nextSqnForRecord));
        }
        Node prev = null;
        if (node.hasPrev()) {
            prev = ((Node)this.sqnToNodeState.get((Object)node.prevSqn)).withNext(node.nextSqn);
            this.sqnToNodeState.put((Object)node.prevSqn, (Object)prev);
        }
        if (node.hasNext()) {
            this.sqnToNodeState.put((Object)node.nextSqn, (Object)((Node)this.sqnToNodeState.get((Object)node.nextSqn)).withPrev(node.prevSqn));
        }
        return prev;
    }

    @Override
    public Iterator<Tuple2<RowData, Long>> iterator() throws Exception {
        ArrayList<Node> list = new ArrayList<Node>();
        for (Node node2 : this.sqnToNodeState.values()) {
            list.add(node2);
        }
        list.sort(Comparator.comparingLong(Node::getSqn));
        return list.stream().map(node -> Tuple2.of((Object)node.row, (Object)node.timestamp)).iterator();
    }

    @Override
    public boolean isEmpty() throws IOException {
        return this.highestSqnAndSizeState.value() == null;
    }

    private RowDataKey toKey(RowData row0) {
        return RowDataKey.toKey(this.keyExtractor.apply(row0), this.keyEqualiser, this.keyHashFunction);
    }
}

