/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.sequencedmultisetstate.linked;

import java.util.Objects;
import org.apache.flink.util.Preconditions;

class MetaSqnInfo {
    public final long highSqn;
    public final long size;

    public MetaSqnInfo(long highSqn, long size) {
        Preconditions.checkArgument((size >= 0L ? 1 : 0) != 0);
        this.highSqn = highSqn;
        this.size = size;
    }

    public static MetaSqnInfo of(long first, long last) {
        return new MetaSqnInfo(first, last);
    }

    public String toString() {
        return "MetaSqnInfo{firstSqn=" + this.highSqn + ", lastSqn=" + this.size + "}";
    }

    public boolean equals(Object o) {
        if (!(o instanceof MetaSqnInfo)) {
            return false;
        }
        MetaSqnInfo that = (MetaSqnInfo)o;
        return this.highSqn == that.highSqn && this.size == that.size;
    }

    public int hashCode() {
        return Objects.hash(this.highSqn, this.size);
    }
}

