/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.api.chat.messages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.agents.api.chat.messages.MessageRole;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;

public class ChatMessage {
    public static final String MESSAGE_TYPE = "messageType";
    private MessageRole role;
    private String content;
    private List<Map<String, Object>> toolCalls;
    private Map<String, Object> extraArgs;

    public ChatMessage() {
        this(MessageRole.SYSTEM, null, null, null);
    }

    public ChatMessage(MessageRole role, String content) {
        this(role, content, null, null);
    }

    public ChatMessage(MessageRole role, String content, Map<String, Object> extraArgs) {
        this(role, content, null, extraArgs);
    }

    public ChatMessage(MessageRole role, String content, List<Map<String, Object>> toolCalls) {
        this(role, content, toolCalls, null);
    }

    public ChatMessage(MessageRole role, String content, List<Map<String, Object>> toolCalls, Map<String, Object> extraArgs) {
        this.role = role != null ? role : MessageRole.SYSTEM;
        this.content = content != null ? content : "";
        this.toolCalls = toolCalls != null ? toolCalls : new ArrayList();
        this.extraArgs = extraArgs != null ? new HashMap<String, Object>(extraArgs) : new HashMap();
        this.extraArgs.put(MESSAGE_TYPE, (Object)this.role);
    }

    public MessageRole getRole() {
        return this.role;
    }

    public void setRole(MessageRole role) {
        this.role = role;
        this.extraArgs.put(MESSAGE_TYPE, (Object)this.role);
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public List<Map<String, Object>> getToolCalls() {
        return this.toolCalls;
    }

    public void setToolCalls(List<Map<String, Object>> toolCalls) {
        this.toolCalls = toolCalls;
    }

    public Map<String, Object> getExtraArgs() {
        return this.extraArgs;
    }

    public void setExtraArgs(Map<String, Object> extraArgs) {
        this.extraArgs = extraArgs != null ? extraArgs : new HashMap();
        this.extraArgs.put(MESSAGE_TYPE, (Object)this.role);
    }

    @JsonIgnore
    public String getText() {
        return this.content;
    }

    public Map<String, Object> getMetadata() {
        return this.extraArgs;
    }

    @JsonIgnore
    public MessageRole getMessageType() {
        return this.role;
    }

    public static ChatMessage user(String content) {
        return new ChatMessage(MessageRole.USER, content);
    }

    public static ChatMessage system(String content) {
        return new ChatMessage(MessageRole.SYSTEM, content);
    }

    public static ChatMessage assistant(String content) {
        return new ChatMessage(MessageRole.ASSISTANT, content);
    }

    public static ChatMessage assistant(String content, List<Map<String, Object>> toolCalls) {
        return new ChatMessage(MessageRole.ASSISTANT, content, toolCalls, new HashMap<String, Object>());
    }

    public static ChatMessage tool(String content) {
        return new ChatMessage(MessageRole.TOOL, content);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChatMessage)) {
            return false;
        }
        ChatMessage that = (ChatMessage)o;
        return Objects.equals((Object)this.role, (Object)that.role) && Objects.equals(this.content, that.content) && Objects.equals(this.toolCalls, that.toolCalls) && Objects.equals(this.extraArgs, that.extraArgs);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.role, this.content, this.toolCalls, this.extraArgs});
    }

    public String toString() {
        return this.role.getValue() + ": " + this.content;
    }
}

