/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.gravitino.Audit;
import org.apache.gravitino.Metalake;
import org.apache.gravitino.dto.AuditDTO;

public class MetalakeDTO
implements Metalake {
    @JsonProperty(value="name")
    private String name;
    @Nullable
    @JsonProperty(value="comment")
    private String comment;
    @Nullable
    @JsonProperty(value="properties")
    private Map<String, String> properties;
    @JsonProperty(value="audit")
    private AuditDTO audit;

    protected MetalakeDTO() {
    }

    protected MetalakeDTO(String name, String comment, Map<String, String> properties, AuditDTO audit) {
        this.name = name;
        this.comment = comment;
        this.properties = properties;
        this.audit = audit;
    }

    public String name() {
        return this.name;
    }

    public String comment() {
        return this.comment;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public Audit auditInfo() {
        return this.audit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MetalakeDTO)) {
            return false;
        }
        MetalakeDTO that = (MetalakeDTO)o;
        return com.google.common.base.Objects.equal((Object)this.name, (Object)that.name) && com.google.common.base.Objects.equal((Object)this.comment, (Object)that.comment) && this.propertyEqual(this.properties, that.properties) && com.google.common.base.Objects.equal((Object)this.audit, (Object)that.audit);
    }

    private boolean propertyEqual(Map<String, String> p1, Map<String, String> p2) {
        if (p1 == null && p2 == null) {
            return true;
        }
        if (p1 != null && p1.isEmpty() && p2 == null) {
            return true;
        }
        if (p2 != null && p2.isEmpty() && p1 == null) {
            return true;
        }
        return Objects.equals(p1, p2);
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.name, this.comment, this.audit, this.properties});
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "MetalakeDTO(name=" + this.name + ", comment=" + this.comment + ", properties=" + String.valueOf(this.properties) + ", audit=" + String.valueOf(this.audit) + ")";
    }

    public static class Builder<S extends Builder> {
        protected String name;
        protected String comment;
        protected Map<String, String> properties;
        protected AuditDTO audit;

        protected Builder() {
        }

        public S withName(String name) {
            this.name = name;
            return (S)this;
        }

        public S withComment(String comment) {
            this.comment = comment;
            return (S)this;
        }

        public S withProperties(Map<String, String> properties) {
            this.properties = properties;
            return (S)this;
        }

        public S withAudit(AuditDTO audit) {
            this.audit = audit;
            return (S)this;
        }

        public MetalakeDTO build() {
            Preconditions.checkArgument((this.name != null && !this.name.isEmpty() ? 1 : 0) != 0, (Object)"name cannot be null or empty");
            Preconditions.checkArgument((this.audit != null ? 1 : 0) != 0, (Object)"audit cannot be null");
            return new MetalakeDTO(this.name, this.comment, this.properties, this.audit);
        }
    }
}

