/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.web.rest;

import com.codahale.metrics.annotation.ResponseMetered;
import com.codahale.metrics.annotation.Timed;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.gravitino.Entity;
import org.apache.gravitino.GravitinoEnv;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.MetadataObjects;
import org.apache.gravitino.authorization.AccessControlDispatcher;
import org.apache.gravitino.dto.responses.NameListResponse;
import org.apache.gravitino.server.authorization.MetadataFilterHelper;
import org.apache.gravitino.server.authorization.NameBindings;
import org.apache.gravitino.server.web.Utils;
import org.apache.gravitino.server.web.rest.ExceptionHandlers;
import org.apache.gravitino.server.web.rest.OperationType;
import org.apache.gravitino.utils.NameIdentifierUtil;

@NameBindings.AccessControlInterfaces
@Path(value="/metalakes/{metalake}/objects/{type}/{fullName}/roles")
public class MetadataObjectRoleOperations {
    private final AccessControlDispatcher accessControlDispatcher = GravitinoEnv.getInstance().accessControlDispatcher();
    @Context
    private HttpServletRequest httpRequest;
    private static final String LIST_ROLE_PRIVILEGE = "METALAKE::OWNER || ROLE::OWNER || ROLE::SELF";

    @GET
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="list-role-by-object.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="list-role-by-object", absolute=true)
    public Response listRoles(@PathParam(value="metalake") String metalake, @PathParam(value="type") String type, @PathParam(value="fullName") String fullName) {
        try {
            MetadataObject object = MetadataObjects.parse((String)fullName, (MetadataObject.Type)MetadataObject.Type.valueOf((String)type.toUpperCase(Locale.ROOT)));
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                Object[] names = this.accessControlDispatcher.listRoleNamesByObject(metalake, object);
                names = (String[])MetadataFilterHelper.filterByExpression((String)metalake, (String)LIST_ROLE_PRIVILEGE, (Entity.EntityType)Entity.EntityType.ROLE, (Object[])names, roleName -> NameIdentifierUtil.ofRole((String)metalake, (String)roleName));
                return Utils.ok((Object)new NameListResponse((String[])names));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleRoleException(OperationType.LIST, "", metalake, e);
        }
    }
}

