/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.catalog;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.iceberg.catalog.BaseSessionCatalog;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.SessionCatalog;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.catalog.ViewCatalog;
import org.apache.iceberg.catalog.ViewSessionCatalog;
import org.apache.iceberg.view.View;
import org.apache.iceberg.view.ViewBuilder;

public abstract class BaseViewSessionCatalog
extends BaseSessionCatalog
implements ViewSessionCatalog {
    private final Cache<String, ViewCatalog> catalogs = Caffeine.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();

    public ViewCatalog asViewCatalog(SessionCatalog.SessionContext context) {
        return (ViewCatalog)this.catalogs.get((Object)context.sessionId(), id -> new AsViewCatalog(context));
    }

    public class AsViewCatalog
    implements ViewCatalog {
        private final SessionCatalog.SessionContext context;

        private AsViewCatalog(SessionCatalog.SessionContext context) {
            this.context = context;
        }

        public String name() {
            return BaseViewSessionCatalog.this.name();
        }

        public List<TableIdentifier> listViews(Namespace namespace) {
            return BaseViewSessionCatalog.this.listViews(this.context, namespace);
        }

        public View loadView(TableIdentifier identifier) {
            return BaseViewSessionCatalog.this.loadView(this.context, identifier);
        }

        public boolean viewExists(TableIdentifier identifier) {
            return BaseViewSessionCatalog.this.viewExists(this.context, identifier);
        }

        public ViewBuilder buildView(TableIdentifier identifier) {
            return BaseViewSessionCatalog.this.buildView(this.context, identifier);
        }

        public boolean dropView(TableIdentifier identifier) {
            return BaseViewSessionCatalog.this.dropView(this.context, identifier);
        }

        public void renameView(TableIdentifier from, TableIdentifier to) {
            BaseViewSessionCatalog.this.renameView(this.context, from, to);
        }

        public void invalidateView(TableIdentifier identifier) {
            BaseViewSessionCatalog.this.invalidateView(this.context, identifier);
        }

        public void initialize(String name, Map<String, String> properties) {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support initialization");
        }
    }
}

