/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.gravitino.storage.relational.JDBCBackend;
import org.apache.gravitino.storage.relational.mapper.provider.base.ModelVersionAliasRelBaseSQLProvider;
import org.apache.gravitino.storage.relational.mapper.provider.h2.ModelVersionAliasRelH2SQLProvider;
import org.apache.gravitino.storage.relational.mapper.provider.postgresql.ModelVersionAliasRelPostgreSQLProvider;
import org.apache.gravitino.storage.relational.po.ModelVersionAliasRelPO;
import org.apache.gravitino.storage.relational.session.SqlSessionFactoryHelper;
import org.apache.ibatis.annotations.Param;

public class ModelVersionAliasSQLProviderFactory {
    private static final Map<JDBCBackend.JDBCBackendType, ModelVersionAliasRelBaseSQLProvider> MODEL_VERSION_META_SQL_PROVIDER_MAP = ImmutableMap.of((Object)((Object)JDBCBackend.JDBCBackendType.MYSQL), (Object)new ModelVersionAliasRelMySQLProvider(), (Object)((Object)JDBCBackend.JDBCBackendType.H2), (Object)new ModelVersionAliasRelH2SQLProvider(), (Object)((Object)JDBCBackend.JDBCBackendType.POSTGRESQL), (Object)new ModelVersionAliasRelPostgreSQLProvider());

    public static ModelVersionAliasRelBaseSQLProvider getProvider() {
        String databaseId = SqlSessionFactoryHelper.getInstance().getSqlSessionFactory().getConfiguration().getDatabaseId();
        JDBCBackend.JDBCBackendType jdbcBackendType = JDBCBackend.JDBCBackendType.fromString(databaseId);
        return MODEL_VERSION_META_SQL_PROVIDER_MAP.get((Object)jdbcBackendType);
    }

    public static String insertModelVersionAliasRels(@Param(value="modelVersionAliasRel") List<ModelVersionAliasRelPO> modelVersionAliasRelPOs) {
        return ModelVersionAliasSQLProviderFactory.getProvider().insertModelVersionAliasRels(modelVersionAliasRelPOs);
    }

    public static String selectModelVersionAliasRelsByModelId(@Param(value="modelId") Long modelId) {
        return ModelVersionAliasSQLProviderFactory.getProvider().selectModelVersionAliasRelsByModelId(modelId);
    }

    public static String selectModelVersionAliasRelsByModelIdAndVersion(@Param(value="modelId") Long modelId, @Param(value="modelVersion") Integer modelVersion) {
        return ModelVersionAliasSQLProviderFactory.getProvider().selectModelVersionAliasRelsByModelIdAndVersion(modelId, modelVersion);
    }

    public static String selectModelVersionAliasRelsByModelIdAndAlias(@Param(value="modelId") Long modelId, @Param(value="alias") String alias) {
        return ModelVersionAliasSQLProviderFactory.getProvider().selectModelVersionAliasRelsByModelIdAndAlias(modelId, alias);
    }

    public static String softDeleteModelVersionAliasRelsBySchemaIdAndModelName(@Param(value="schemaId") Long schemaId, @Param(value="modelName") String modelName) {
        return ModelVersionAliasSQLProviderFactory.getProvider().softDeleteModelVersionAliasRelsBySchemaIdAndModelName(schemaId, modelName);
    }

    public static String softDeleteModelVersionAliasRelsByModelIdAndVersion(@Param(value="modelId") Long modelId, @Param(value="modelVersion") Integer modelVersion) {
        return ModelVersionAliasSQLProviderFactory.getProvider().softDeleteModelVersionAliasRelsByModelIdAndVersion(modelId, modelVersion);
    }

    public static String softDeleteModelVersionAliasRelsByModelIdAndAlias(@Param(value="modelId") Long modelId, @Param(value="alias") String alias) {
        return ModelVersionAliasSQLProviderFactory.getProvider().softDeleteModelVersionAliasRelsByModelIdAndAlias(modelId, alias);
    }

    public static String softDeleteModelVersionAliasRelsBySchemaId(@Param(value="schemaId") Long schemaId) {
        return ModelVersionAliasSQLProviderFactory.getProvider().softDeleteModelVersionAliasRelsBySchemaId(schemaId);
    }

    public static String softDeleteModelVersionAliasRelsByCatalogId(@Param(value="catalogId") Long catalogId) {
        return ModelVersionAliasSQLProviderFactory.getProvider().softDeleteModelVersionAliasRelsByCatalogId(catalogId);
    }

    public static String softDeleteModelVersionAliasRelsByMetalakeId(@Param(value="metalakeId") Long metalakeId) {
        return ModelVersionAliasSQLProviderFactory.getProvider().softDeleteModelVersionAliasRelsByMetalakeId(metalakeId);
    }

    public static String deleteModelVersionAliasRelsByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return ModelVersionAliasSQLProviderFactory.getProvider().deleteModelVersionAliasRelsByLegacyTimeline(legacyTimeline, limit);
    }

    public static String updateModelVersionAliasRel(@Param(value="modelVersionAliasRel") List<ModelVersionAliasRelPO> modelVersionAliasRelPOs) {
        return ModelVersionAliasSQLProviderFactory.getProvider().updateModelVersionAliasRel(modelVersionAliasRelPOs);
    }

    static class ModelVersionAliasRelMySQLProvider
    extends ModelVersionAliasRelBaseSQLProvider {
        ModelVersionAliasRelMySQLProvider() {
        }
    }
}

