/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.client.utils.filesystem;

import io.openlineage.client.utils.DatasetIdentifier;
import io.openlineage.client.utils.filesystem.FilesystemDatasetExtractor;
import io.openlineage.client.utils.filesystem.FilesystemUriSanitizer;
import io.openlineage.client.utils.filesystem.GenericFilesystemDatasetExtractor;
import io.openlineage.client.utils.filesystem.LocalFilesystemDatasetExtractor;
import io.openlineage.client.utils.filesystem.ObjectStorageDatasetExtractor;
import java.net.URI;

public class FilesystemDatasetUtils {
    private static final FilesystemDatasetExtractor[] extractors = new FilesystemDatasetExtractor[]{new LocalFilesystemDatasetExtractor(), new ObjectStorageDatasetExtractor("s3"), new ObjectStorageDatasetExtractor("gs"), new ObjectStorageDatasetExtractor("wasbs")};

    private static FilesystemDatasetExtractor getExtractor(URI location) {
        for (FilesystemDatasetExtractor extractor : extractors) {
            if (!extractor.isDefinedAt(location)) continue;
            return extractor;
        }
        return new GenericFilesystemDatasetExtractor();
    }

    public static DatasetIdentifier fromLocation(URI location) {
        FilesystemDatasetExtractor extractor = FilesystemDatasetUtils.getExtractor(location);
        return extractor.extract(location);
    }

    public static DatasetIdentifier fromLocationAndName(URI location, String name) {
        FilesystemDatasetExtractor extractor = FilesystemDatasetUtils.getExtractor(location);
        return extractor.extract(location, name);
    }

    public static URI toLocation(DatasetIdentifier di) {
        String name;
        String namespace = di.getNamespace();
        if (!namespace.contains(":/")) {
            namespace = namespace + ":/";
        }
        if ("/".equals(name = di.getName())) {
            return new URI(namespace);
        }
        String location = FilesystemUriSanitizer.removeLastSlash(namespace) + "/" + FilesystemUriSanitizer.removeFirstSlash(name);
        return new URI(location);
    }
}

