/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance;

import com.lancedb.lance.Dataset;
import com.lancedb.lance.FragmentMetadata;
import com.lancedb.lance.JniLoader;
import com.lancedb.lance.WriteParams;
import com.lancedb.lance.ipc.LanceScanner;
import com.lancedb.lance.ipc.ScanOptions;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.arrow.c.ArrowArrayStream;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.vector.VectorSchemaRoot;

public class Fragment {
    private final Dataset dataset;
    private final FragmentMetadata fragmentMetadata;

    public Fragment(Dataset dataset, int fragmentId) {
        Preconditions.checkNotNull((Object)dataset);
        this.dataset = dataset;
        this.fragmentMetadata = dataset.getFragment((int)fragmentId).fragmentMetadata;
    }

    public Fragment(Dataset dataset, FragmentMetadata fragmentMetadata) {
        Preconditions.checkNotNull((Object)dataset);
        Preconditions.checkNotNull((Object)fragmentMetadata);
        this.dataset = dataset;
        this.fragmentMetadata = fragmentMetadata;
    }

    public FragmentMetadata metadata() {
        return this.fragmentMetadata;
    }

    public LanceScanner newScan() {
        return LanceScanner.create(this.dataset, new ScanOptions.Builder().fragmentIds(Arrays.asList(this.fragmentMetadata.getId())).build(), this.dataset.allocator());
    }

    public LanceScanner newScan(long batchSize) {
        return LanceScanner.create(this.dataset, new ScanOptions.Builder().fragmentIds(Arrays.asList(this.fragmentMetadata.getId())).batchSize(batchSize).build(), this.dataset.allocator());
    }

    public LanceScanner newScan(ScanOptions options) {
        Preconditions.checkNotNull((Object)options);
        return LanceScanner.create(this.dataset, new ScanOptions.Builder(options).fragmentIds(Arrays.asList(this.fragmentMetadata.getId())).build(), this.dataset.allocator());
    }

    private native int countRowsNative(Dataset var1, long var2);

    public int getId() {
        return this.fragmentMetadata.getId();
    }

    public int countRows() {
        return this.countRowsNative(this.dataset, this.fragmentMetadata.getId());
    }

    /*
     * Exception decompiling
     */
    public static List<FragmentMetadata> create(String datasetUri, BufferAllocator allocator, VectorSchemaRoot root, WriteParams params) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static List<FragmentMetadata> create(String datasetUri, ArrowArrayStream stream, WriteParams params) {
        Preconditions.checkNotNull((Object)datasetUri);
        Preconditions.checkNotNull((Object)stream);
        Preconditions.checkNotNull((Object)params);
        return Fragment.createWithFfiStream(datasetUri, stream.memoryAddress(), params.getMaxRowsPerFile(), params.getMaxRowsPerGroup(), params.getMaxBytesPerFile(), params.getMode(), params.getStorageOptions());
    }

    private static native List<FragmentMetadata> createWithFfiArray(String var0, long var1, long var3, Optional<Integer> var5, Optional<Integer> var6, Optional<Long> var7, Optional<String> var8, Map<String, String> var9);

    private static native List<FragmentMetadata> createWithFfiStream(String var0, long var1, Optional<Integer> var3, Optional<Integer> var4, Optional<Long> var5, Optional<String> var6, Map<String, String> var7);

    static {
        JniLoader.ensureLoaded();
    }
}

