/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.index.vector;

import org.apache.commons.lang3.builder.ToStringBuilder;

public class IvfBuildParams {
    private final int numPartitions;
    private final int maxIters;
    private final int sampleRate;
    private final int shufflePartitionBatches;
    private final int shufflePartitionConcurrency;
    private final boolean useResidual;

    private IvfBuildParams(Builder builder) {
        this.numPartitions = builder.numPartitions;
        this.maxIters = builder.maxIters;
        this.sampleRate = builder.sampleRate;
        this.shufflePartitionBatches = builder.shufflePartitionBatches;
        this.shufflePartitionConcurrency = builder.shufflePartitionConcurrency;
        this.useResidual = builder.useResidual;
    }

    public int getNumPartitions() {
        return this.numPartitions;
    }

    public int getMaxIters() {
        return this.maxIters;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public int getShufflePartitionBatches() {
        return this.shufflePartitionBatches;
    }

    public int getShufflePartitionConcurrency() {
        return this.shufflePartitionConcurrency;
    }

    public boolean useResidual() {
        return this.useResidual;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("numPartitions", this.numPartitions).append("maxIters", this.maxIters).append("sampleRate", this.sampleRate).append("shufflePartitionBatches", this.shufflePartitionBatches).append("shufflePartitionConcurrency", this.shufflePartitionConcurrency).append("useResidual", this.useResidual).toString();
    }

    public static class Builder {
        private int numPartitions = 32;
        private int maxIters = 50;
        private int sampleRate = 256;
        private int shufflePartitionBatches = 10240;
        private int shufflePartitionConcurrency = 2;
        private boolean useResidual = true;

        public Builder setNumPartitions(int numPartitions) {
            this.numPartitions = numPartitions;
            return this;
        }

        public Builder setMaxIters(int maxIters) {
            this.maxIters = maxIters;
            return this;
        }

        public Builder setSampleRate(int sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public Builder setShufflePartitionBatches(int shufflePartitionBatches) {
            this.shufflePartitionBatches = shufflePartitionBatches;
            return this;
        }

        public Builder setShufflePartitionConcurrency(int shufflePartitionConcurrency) {
            this.shufflePartitionConcurrency = shufflePartitionConcurrency;
            return this;
        }

        public Builder setUseResidual(boolean useResidual) {
            this.useResidual = useResidual;
            return this;
        }

        public IvfBuildParams build() {
            return new IvfBuildParams(this);
        }
    }
}

