/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.audit.FileAuditWriter;
import org.apache.gravitino.audit.v2.SimpleFormatterV2;
import org.apache.gravitino.config.ConfigBuilder;
import org.apache.gravitino.config.ConfigEntry;
import org.apache.gravitino.stats.storage.LancePartitionStatisticStorageFactory;

public class Configs {
    public static final String RELATIONAL_ENTITY_STORE = "relational";
    public static final String ENTITY_STORE_KEY = "gravitino.entity.store";
    public static final String DEFAULT_ENTITY_RELATIONAL_STORE = "JDBCBackend";
    public static final String ENTITY_RELATIONAL_STORE_KEY = "gravitino.entity.store.relational";
    public static final String ENTITY_RELATIONAL_JDBC_BACKEND_URL_KEY = "gravitino.entity.store.relational.jdbcUrl";
    public static final String ENTITY_RELATIONAL_JDBC_BACKEND_DRIVER_KEY = "gravitino.entity.store.relational.jdbcDriver";
    public static final String ENTITY_RELATIONAL_JDBC_BACKEND_USER_KEY = "gravitino.entity.store.relational.jdbcUser";
    public static final String ENTITY_RELATIONAL_JDBC_BACKEND_PASSWORD_KEY = "gravitino.entity.store.relational.jdbcPassword";
    public static final String ENTITY_RELATIONAL_JDBC_BACKEND_MAX_CONNECTION_KEYS = "gravitino.entity.store.relational.maxConnections";
    public static final String ENTITY_RELATIONAL_JDBC_BACKEND_MAX_WAIT_MILLIS_CONNECTION_KEY = "gravitino.entity.store.relational.maxWaitMillis";
    public static final String ENTITY_RELATIONAL_JDBC_BACKEND_STORAGE_PATH_KEY = "gravitino.entity.store.relational.storagePath";
    public static final Long DEFAULT_DELETE_AFTER_TIME;
    public static final String STORE_DELETE_AFTER_TIME_KEY = "gravitino.entity.store.deleteAfterTimeMs";
    public static final Long DEFAULT_STORE_DELETE_AFTER_TIME;
    public static final Long MAX_DELETE_TIME_ALLOW;
    public static final Long MIN_DELETE_TIME_ALLOW;
    public static final String VERSION_RETENTION_COUNT_KEY = "gravitino.entity.store.versionRetentionCount";
    public static final Long DEFAULT_VERSION_RETENTION_COUNT;
    public static final Long MAX_VERSION_RETENTION_COUNT;
    public static final Long MIN_VERSION_RETENTION_COUNT;
    public static final String DEFAULT_RELATIONAL_JDBC_BACKEND_PATH;
    public static final String DEFAULT_RELATIONAL_JDBC_BACKEND_URL = "jdbc:h2";
    public static final String DEFAULT_RELATIONAL_JDBC_BACKEND_DRIVER = "org.h2.Driver";
    public static final String DEFAULT_RELATIONAL_JDBC_BACKEND_USERNAME = "gravitino";
    public static final String DEFAULT_RELATIONAL_JDBC_BACKEND_PASSWORD = "gravitino";
    public static final int DEFAULT_RELATIONAL_JDBC_BACKEND_MAX_CONNECTIONS = 100;
    public static final int DEFAULT_GRAVITINO_AUTHORIZATION_THREAD_POOL_SIZE = 100;
    public static final long DEFAULT_RELATIONAL_JDBC_BACKEND_MAX_WAIT_MILLISECONDS = 1000L;
    public static final int GARBAGE_COLLECTOR_SINGLE_DELETION_LIMIT = 100;
    public static final long MAX_NODE_IN_MEMORY = 100000L;
    public static final long MIN_NODE_IN_MEMORY = 1000L;
    public static final long CLEAN_INTERVAL_IN_SECS = 60L;
    public static final ConfigEntry<String> ENTITY_STORE;
    public static final ConfigEntry<String> ENTITY_RELATIONAL_STORE;
    public static final ConfigEntry<String> ENTITY_RELATIONAL_JDBC_BACKEND_URL;
    public static final ConfigEntry<String> ENTITY_RELATIONAL_JDBC_BACKEND_DRIVER;
    public static final ConfigEntry<String> ENTITY_RELATIONAL_JDBC_BACKEND_USER;
    public static final ConfigEntry<String> ENTITY_RELATIONAL_JDBC_BACKEND_PASSWORD;
    public static final ConfigEntry<Integer> ENTITY_RELATIONAL_JDBC_BACKEND_MAX_CONNECTIONS;
    public static final ConfigEntry<Long> ENTITY_RELATIONAL_JDBC_BACKEND_WAIT_MILLISECONDS;
    public static final ConfigEntry<String> ENTITY_RELATIONAL_JDBC_BACKEND_PATH;
    public static final ConfigEntry<Long> CATALOG_CACHE_EVICTION_INTERVAL_MS;
    public static final ConfigEntry<Boolean> CATALOG_LOAD_ISOLATED;
    public static final ConfigEntry<String> AUTHENTICATOR;
    public static final ConfigEntry<List<String>> AUTHENTICATORS;
    public static final ConfigEntry<Long> STORE_TRANSACTION_MAX_SKEW_TIME;
    public static final ConfigEntry<Long> STORE_DELETE_AFTER_TIME;
    public static final ConfigEntry<Long> VERSION_RETENTION_COUNT;
    public static final ConfigEntry<Long> TREE_LOCK_MAX_NODE_IN_MEMORY;
    public static final ConfigEntry<Long> TREE_LOCK_MIN_NODE_IN_MEMORY;
    public static final ConfigEntry<Long> TREE_LOCK_CLEAN_INTERVAL;
    public static final ConfigEntry<Boolean> ENABLE_AUTHORIZATION;
    public static final ConfigEntry<String> AUTHORIZATION_IMPL;
    public static final ConfigEntry<Integer> GRAVITINO_AUTHORIZATION_THREAD_POOL_SIZE;
    public static final ConfigEntry<List<String>> SERVICE_ADMINS;
    public static final int DEFAULT_METRICS_TIME_SLIDING_WINDOW_SECONDS = 60;
    public static final ConfigEntry<Integer> METRICS_TIME_SLIDING_WINDOW_SECONDS;
    public static final ConfigEntry<List<String>> REST_API_EXTENSION_PACKAGES;
    public static final String AUDIT_LOG_WRITER_CONFIG_PREFIX = "gravitino.audit.writer.";
    public static final ConfigEntry<Boolean> AUDIT_LOG_ENABLED_CONF;
    public static final ConfigEntry<String> AUDIT_LOG_WRITER_CLASS_NAME;
    public static final ConfigEntry<String> AUDIT_LOG_FORMATTER_CLASS_NAME;
    public static final ConfigEntry<List<String>> VISIBLE_CONFIGS;
    public static final ConfigEntry<Boolean> CACHE_ENABLED;
    public static final ConfigEntry<Integer> CACHE_MAX_ENTRIES;
    public static final ConfigEntry<Long> CACHE_EXPIRATION_TIME;
    public static final ConfigEntry<Boolean> CACHE_STATS_ENABLED;
    public static final ConfigEntry<Boolean> CACHE_WEIGHER_ENABLED;
    public static final ConfigEntry<String> CACHE_IMPLEMENTATION;
    public static final ConfigEntry<Integer> CACHE_LOCK_SEGMENTS;
    public static final ConfigEntry<String> JOB_STAGING_DIR;
    public static final ConfigEntry<String> JOB_EXECUTOR;
    public static final ConfigEntry<Long> JOB_STAGING_DIR_KEEP_TIME_IN_MS;
    public static final ConfigEntry<Long> JOB_STATUS_PULL_INTERVAL_IN_MS;
    public static final ConfigEntry<String> PARTITION_STATS_STORAGE_FACTORY_CLASS;

    private Configs() {
    }

    static {
        DEFAULT_STORE_DELETE_AFTER_TIME = DEFAULT_DELETE_AFTER_TIME = Long.valueOf(604800000L);
        MAX_DELETE_TIME_ALLOW = 2592000000L;
        MIN_DELETE_TIME_ALLOW = 600000L;
        DEFAULT_VERSION_RETENTION_COUNT = 1L;
        MAX_VERSION_RETENTION_COUNT = 10L;
        MIN_VERSION_RETENTION_COUNT = 1L;
        DEFAULT_RELATIONAL_JDBC_BACKEND_PATH = String.join((CharSequence)File.separator, System.getenv("GRAVITINO_HOME"), "data", "jdbc");
        ENTITY_STORE = new ConfigBuilder(ENTITY_STORE_KEY).doc("Which storage implementation to use").version("0.1.0").stringConf().createWithDefault((Object)RELATIONAL_ENTITY_STORE);
        ENTITY_RELATIONAL_STORE = new ConfigBuilder(ENTITY_RELATIONAL_STORE_KEY).doc("Detailed implementation of relational storage").version("0.5.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").createWithDefault((Object)DEFAULT_ENTITY_RELATIONAL_STORE);
        ENTITY_RELATIONAL_JDBC_BACKEND_URL = new ConfigBuilder(ENTITY_RELATIONAL_JDBC_BACKEND_URL_KEY).doc("Connection URL of `JDBCBackend`").version("0.5.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").createWithDefault((Object)DEFAULT_RELATIONAL_JDBC_BACKEND_URL);
        ENTITY_RELATIONAL_JDBC_BACKEND_DRIVER = new ConfigBuilder(ENTITY_RELATIONAL_JDBC_BACKEND_DRIVER_KEY).doc("Driver Name of `JDBCBackend`").version("0.5.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").createWithDefault((Object)DEFAULT_RELATIONAL_JDBC_BACKEND_DRIVER);
        ENTITY_RELATIONAL_JDBC_BACKEND_USER = new ConfigBuilder(ENTITY_RELATIONAL_JDBC_BACKEND_USER_KEY).doc("Username of `JDBCBackend`").version("0.5.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").createWithDefault((Object)"gravitino");
        ENTITY_RELATIONAL_JDBC_BACKEND_PASSWORD = new ConfigBuilder(ENTITY_RELATIONAL_JDBC_BACKEND_PASSWORD_KEY).doc("Password of `JDBCBackend`").version("0.5.0").stringConf().createWithDefault((Object)"gravitino");
        ENTITY_RELATIONAL_JDBC_BACKEND_MAX_CONNECTIONS = new ConfigBuilder(ENTITY_RELATIONAL_JDBC_BACKEND_MAX_CONNECTION_KEYS).doc("The maximum number of connections for the JDBC Backend connection pool").version("0.9.0").intConf().createWithDefault((Object)100);
        ENTITY_RELATIONAL_JDBC_BACKEND_WAIT_MILLISECONDS = new ConfigBuilder(ENTITY_RELATIONAL_JDBC_BACKEND_MAX_WAIT_MILLIS_CONNECTION_KEY).doc("The maximum wait time in milliseconds for a connection from the JDBC Backend connection pool").version("0.9.0").longConf().createWithDefault((Object)1000L);
        ENTITY_RELATIONAL_JDBC_BACKEND_PATH = new ConfigBuilder(ENTITY_RELATIONAL_JDBC_BACKEND_STORAGE_PATH_KEY).doc("The storage path for JDBC storage implementation. It supports both absolute and relative path, if the value is a relative path, the final path is `${GRAVITINO_HOME}/${PATH_YOU_HAVA_SET}`, default value is `${GRAVITINO_HOME}/data/jdbc`").version("0.6.0").stringConf().createWithDefault((Object)DEFAULT_RELATIONAL_JDBC_BACKEND_PATH);
        CATALOG_CACHE_EVICTION_INTERVAL_MS = new ConfigBuilder("gravitino.catalog.cache.evictionIntervalMs").doc("The interval in milliseconds to evict the catalog cache").version("0.1.0").longConf().createWithDefault((Object)3600000L);
        CATALOG_LOAD_ISOLATED = new ConfigBuilder("gravitino.catalog.classloader.isolated").doc("Whether to load the catalog in an isolated classloader").version("0.1.0").booleanConf().createWithDefault((Object)true);
        AUTHENTICATOR = new ConfigBuilder("gravitino.authenticator").doc("The authenticator which Gravitino uses. Multiple authenticators separated by commas").version("0.3.0").deprecated().stringConf().createWithDefault((Object)"simple");
        AUTHENTICATORS = new ConfigBuilder("gravitino.authenticators").doc("The authenticators which Gravitino uses. Multiple authenticators separated by commas").version("0.6.0").alternatives((List)Lists.newArrayList((Object[])new String[]{"gravitino.authenticator"})).stringConf().toSequence().checkValue(valueList -> valueList != null && valueList.stream().allMatch(StringUtils::isNotBlank), "The value can't be blank").createWithDefault((Object)Lists.newArrayList((Object[])new String[]{"simple"}));
        STORE_TRANSACTION_MAX_SKEW_TIME = new ConfigBuilder("gravitino.entity.store.maxTransactionSkewTimeMs").doc("The maximum skew time of transactions in milliseconds").version("0.3.0").longConf().createWithDefault((Object)2000L);
        STORE_DELETE_AFTER_TIME = new ConfigBuilder(STORE_DELETE_AFTER_TIME_KEY).doc(String.format("The maximum time in milliseconds that the deleted data and old version data is kept, max delete time allow is %s ms(30 days), min delete time allow is %s ms(10 minutes)", MAX_DELETE_TIME_ALLOW, MIN_DELETE_TIME_ALLOW)).version("0.5.0").longConf().checkValue(v -> v >= MIN_DELETE_TIME_ALLOW && v <= MAX_DELETE_TIME_ALLOW, String.format("The value of %s is out of range, which must be between %s and %s", STORE_DELETE_AFTER_TIME_KEY, MIN_DELETE_TIME_ALLOW, MAX_DELETE_TIME_ALLOW)).createWithDefault((Object)DEFAULT_STORE_DELETE_AFTER_TIME);
        VERSION_RETENTION_COUNT = new ConfigBuilder(VERSION_RETENTION_COUNT_KEY).doc(String.format("The count of versions allowed to be retained, including the current version, max version retention count is %s, min version retention count is %s", MAX_VERSION_RETENTION_COUNT, MIN_VERSION_RETENTION_COUNT)).version("0.5.0").longConf().checkValue(v -> v >= MIN_VERSION_RETENTION_COUNT && v <= MAX_VERSION_RETENTION_COUNT, String.format("The value of %s is out of range, which must be between %s and %s", VERSION_RETENTION_COUNT_KEY, MIN_VERSION_RETENTION_COUNT, MAX_VERSION_RETENTION_COUNT)).createWithDefault((Object)DEFAULT_VERSION_RETENTION_COUNT);
        TREE_LOCK_MAX_NODE_IN_MEMORY = new ConfigBuilder("gravitino.lock.maxNodes").doc("The maximum number of tree lock nodes to keep in memory").version("0.4.0").longConf().createWithDefault((Object)100000L);
        TREE_LOCK_MIN_NODE_IN_MEMORY = new ConfigBuilder("gravitino.lock.minNodes").doc("The minimum number of tree lock nodes to keep in memory").version("0.4.0").longConf().createWithDefault((Object)1000L);
        TREE_LOCK_CLEAN_INTERVAL = new ConfigBuilder("gravitino.lock.cleanIntervalInSecs").doc("The interval in seconds to clean up the stale tree lock nodes").version("0.4.0").longConf().createWithDefault((Object)60L);
        ENABLE_AUTHORIZATION = new ConfigBuilder("gravitino.authorization.enable").doc("Enable the authorization").version("0.5.0").booleanConf().createWithDefault((Object)false);
        AUTHORIZATION_IMPL = new ConfigBuilder("gravitino.authorization.impl").doc("Metadata authorization implementation").version("1.0.0").stringConf().createWithDefault((Object)"org.apache.gravitino.server.authorization.jcasbin.JcasbinAuthorizer");
        GRAVITINO_AUTHORIZATION_THREAD_POOL_SIZE = new ConfigBuilder("gravitino.authorization.threadPoolSize").doc("The thread pool size of metadata authorization requests").version("1.0.0").intConf().createWithDefault((Object)100);
        SERVICE_ADMINS = new ConfigBuilder("gravitino.authorization.serviceAdmins").doc("The admins of Gravitino service").version("0.5.0").stringConf().toSequence().checkValue(valueList -> valueList != null && valueList.stream().allMatch(StringUtils::isNotBlank), "The value can't be blank").create();
        METRICS_TIME_SLIDING_WINDOW_SECONDS = new ConfigBuilder("gravitino.metrics.timeSlidingWindowSecs").doc("The seconds of Gravitino metrics time sliding window").version("0.5.1").intConf().createWithDefault((Object)60);
        REST_API_EXTENSION_PACKAGES = new ConfigBuilder("gravitino.server.rest.extensionPackages").doc("Comma-separated list of REST API packages to expand").version("0.6.0").stringConf().toSequence().createWithDefault(Collections.emptyList());
        AUDIT_LOG_ENABLED_CONF = new ConfigBuilder("gravitino.audit.enabled").doc("Gravitino audit log enable flag").version("0.7.0").booleanConf().createWithDefault((Object)false);
        AUDIT_LOG_WRITER_CLASS_NAME = new ConfigBuilder("gravitino.audit.writer.className").doc("Gravitino audit log writer class name").version("0.7.0").stringConf().createWithDefault((Object)FileAuditWriter.class.getName());
        AUDIT_LOG_FORMATTER_CLASS_NAME = new ConfigBuilder("gravitino.audit.formatter.className").doc("Gravitino event log formatter class name").version("0.7.0").stringConf().createWithDefault((Object)SimpleFormatterV2.class.getName());
        VISIBLE_CONFIGS = new ConfigBuilder("gravitino.server.visibleConfigs").doc("List of configs that are visible in the config servlet").version("0.9.0").stringConf().toSequence().createWithDefault(Collections.emptyList());
        CACHE_ENABLED = new ConfigBuilder("gravitino.cache.enabled").doc("Whether to enable the cached Entity store.").version("1.0.0").booleanConf().createWithDefault((Object)true);
        CACHE_MAX_ENTRIES = new ConfigBuilder("gravitino.cache.maxEntries").doc("Maximum number of entries allowed in the cache.").version("1.0.0").intConf().checkValue(value -> value > 0, "The value must be a positive number").createWithDefault((Object)10000);
        CACHE_EXPIRATION_TIME = new ConfigBuilder("gravitino.cache.expireTimeInMs").doc("Time-to-live (TTL) for each cache entry after it is written, in milliseconds.Default is 3,600,000 ms (1 hour).").version("1.0.0").longConf().checkValue(value -> value >= 0L, "The value must be a positive number").createWithDefault((Object)3600000L);
        CACHE_STATS_ENABLED = new ConfigBuilder("gravitino.cache.enableStats").doc("Whether to enable cache statistics logging such as hit/miss count, load failures, and size.").version("1.0.0").booleanConf().createWithDefault((Object)false);
        CACHE_WEIGHER_ENABLED = new ConfigBuilder("gravitino.cache.enableWeigher").doc("Whether to enable weighted cache eviction. Entries are evicted based on weight instead of count.").version("1.0.0").booleanConf().createWithDefault((Object)true);
        CACHE_IMPLEMENTATION = new ConfigBuilder("gravitino.cache.implementation").doc("Which cache implementation to use").version("1.0.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").createWithDefault((Object)"caffeine");
        CACHE_LOCK_SEGMENTS = new ConfigBuilder("gravitino.cache.lockSegments").doc("Number of lock segments for cache concurrency optimization. This configuration controls the granularity of locking in the cache system. Instead of using a single global lock, Gravitino uses Guava's Striped<Lock> to divide locks into segments, allowing concurrent access to different cache entries while maintaining thread safety. Higher values reduce lock contention but increase memory overhead. The actual number of segments will be rounded up to the nearest power of 2 for optimal performance. See: https://github.com/google/guava/wiki/StripedExplained").version("1.0.0").intConf().checkValue(value -> value > 0, "Lock segments must be positive.").createWithDefault((Object)16);
        JOB_STAGING_DIR = new ConfigBuilder("gravitino.job.stagingDir").doc("Directory for managing staging files when running jobs.").version("1.0.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").createWithDefault((Object)"/tmp/gravitino/jobs/staging");
        JOB_EXECUTOR = new ConfigBuilder("gravitino.job.executor").doc("The executor to run jobs, by default it is 'local', user can implement their own executor and set it here.").version("1.0.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").createWithDefault((Object)"local");
        JOB_STAGING_DIR_KEEP_TIME_IN_MS = new ConfigBuilder("gravitino.job.stagingDirKeepTimeInMs").doc("The time in milliseconds to keep the staging files of the finished job in the job staging directory. The minimum recommended value is 10 minutes if you're not testing.").version("1.0.0").longConf().checkValue(value -> value > 0L, "The value must be a positive number").createWithDefault((Object)604800000L);
        JOB_STATUS_PULL_INTERVAL_IN_MS = new ConfigBuilder("gravitino.job.statusPullIntervalInMs").doc("The interval in milliseconds to pull the job status from the job executor. The minimum recommended value is 1 minute if you're not testing.").version("1.0.0").longConf().checkValue(value -> value > 0L, "The value must be a positive number").createWithDefault((Object)300000L);
        PARTITION_STATS_STORAGE_FACTORY_CLASS = new ConfigBuilder("gravitino.stats.partition.storageFactoryClass").doc("The partition stats storage factory class.").version("1.0.0").stringConf().createWithDefault((Object)LancePartitionStatisticStorageFactory.class.getCanonicalName());
    }
}

