/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.starrocks.converter;

import java.time.LocalDate;
import java.time.LocalDateTime;
import org.apache.gravitino.catalog.jdbc.converter.JdbcColumnDefaultValueConverter;
import org.apache.gravitino.catalog.jdbc.converter.JdbcTypeConverter;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.expressions.Expression;
import org.apache.gravitino.rel.expressions.UnparsedExpression;
import org.apache.gravitino.rel.expressions.literals.Literals;
import org.apache.gravitino.rel.types.Decimal;
import org.apache.gravitino.rel.types.Type;
import org.apache.gravitino.rel.types.Types;

public class StarRocksColumnDefaultValueConverter
extends JdbcColumnDefaultValueConverter {
    public Expression toGravitino(JdbcTypeConverter.JdbcTypeBean columnType, String columnDefaultValue, boolean isExpression, boolean nullable) {
        if (columnDefaultValue == null) {
            return nullable ? Literals.NULL : Column.DEFAULT_VALUE_NOT_SET;
        }
        if (columnDefaultValue.equalsIgnoreCase("NULL")) {
            return Literals.NULL;
        }
        if (isExpression) {
            if (columnDefaultValue.equals("CURRENT_TIMESTAMP")) {
                return Column.DEFAULT_VALUE_OF_CURRENT_TIMESTAMP;
            }
            return UnparsedExpression.of((String)columnDefaultValue);
        }
        switch (columnType.getTypeName().toLowerCase()) {
            case "tinyint": {
                return Literals.byteLiteral((Byte)Byte.valueOf(columnDefaultValue));
            }
            case "smallint": {
                return Literals.shortLiteral((Short)Short.valueOf(columnDefaultValue));
            }
            case "int": {
                return Literals.integerLiteral((Integer)Integer.valueOf(columnDefaultValue));
            }
            case "bigint": {
                return Literals.longLiteral((Long)Long.valueOf(columnDefaultValue));
            }
            case "float": {
                return Literals.floatLiteral((Float)Float.valueOf(columnDefaultValue));
            }
            case "double": {
                return Literals.doubleLiteral((Double)Double.valueOf(columnDefaultValue));
            }
            case "decimal": {
                return Literals.decimalLiteral((Decimal)Decimal.of((String)columnDefaultValue, (int)columnType.getColumnSize(), (int)columnType.getScale()));
            }
            case "date": {
                return Literals.dateLiteral((LocalDate)LocalDate.parse(columnDefaultValue, DATE_FORMATTER));
            }
            case "datetime": {
                return "CURRENT_TIMESTAMP".equals(columnDefaultValue) ? Column.DEFAULT_VALUE_OF_CURRENT_TIMESTAMP : Literals.timestampLiteral((LocalDateTime)LocalDateTime.parse(columnDefaultValue, DATE_TIME_FORMATTER));
            }
            case "varchar": {
                return Literals.of((Object)columnDefaultValue, (Type)Types.VarCharType.of((int)columnType.getColumnSize()));
            }
            case "char": {
                return Literals.of((Object)columnDefaultValue, (Type)Types.FixedCharType.of((int)columnType.getColumnSize()));
            }
        }
        throw new IllegalArgumentException("Unknown data columnType for literal: " + String.valueOf(columnType));
    }
}

