/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.mapred.JobConf;
import org.apache.paimon.utils.StringUtils;

public class LocationKeyExtractor {
    public static final String TBPROPERTIES_LOCATION_KEY = "paimon_location";
    public static final String INTERNAL_LOCATION = "paimon.internal.location";

    public static String getPaimonLocation(@Nullable Configuration conf, Properties properties) {
        String location = properties.getProperty(TBPROPERTIES_LOCATION_KEY);
        if (location != null) {
            return location;
        }
        location = properties.getProperty("location");
        if (location != null) {
            location = LocationKeyExtractor.tableLocation(location, properties);
            if (conf != null) {
                try {
                    return Warehouse.getDnsPath((Path)new Path(location), (Configuration)conf).toString();
                }
                catch (MetaException e) {
                    throw new RuntimeException(e);
                }
            }
            return location;
        }
        if (conf != null) {
            return conf.get("table.original.path");
        }
        return null;
    }

    public static String getPaimonLocation(Configuration conf, Table table) throws MetaException {
        String location;
        Map params = table.getParameters();
        if (params != null && (location = (String)params.get(TBPROPERTIES_LOCATION_KEY)) != null) {
            return location;
        }
        location = table.getSd().getLocation();
        if (location != null) {
            location = Warehouse.getDnsPath((Path)new Path(location), (Configuration)conf).toString();
            table.getSd().setLocation(location);
        }
        return location;
    }

    public static String getPaimonLocation(JobConf conf) {
        String location = conf.get(INTERNAL_LOCATION);
        if (location != null) {
            return location;
        }
        location = conf.get(TBPROPERTIES_LOCATION_KEY);
        if (location != null) {
            return location;
        }
        location = conf.get("table.original.path");
        if (location != null) {
            return location;
        }
        location = conf.get("mapreduce.input.fileinputformat.inputdir");
        if (location != null) {
            Path path;
            try {
                FileSystem fs = path.getFileSystem((Configuration)conf);
                for (path = new Path(location); path != null && !fs.exists(new Path(path, "schema")); path = path.getParent()) {
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            if (path != null) {
                try {
                    return Warehouse.getDnsPath((Path)path, (Configuration)conf).toString();
                }
                catch (MetaException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return null;
    }

    private static String tableLocation(String location, Properties properties) {
        String partitionProperty = properties.getProperty("partition_columns");
        if (StringUtils.isEmpty((CharSequence)partitionProperty)) {
            return location;
        }
        List<String> partitionKeys = Arrays.asList(partitionProperty.split("/"));
        return location.split("/" + partitionKeys.get(0) + "=")[0];
    }
}

