/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.hadoop.hive.conf.HiveConf;

public class SerializableHiveConf
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient HiveConf conf;
    private byte[] serializedConf;

    public SerializableHiveConf(HiveConf conf) {
        this.conf = conf;
    }

    public HiveConf conf() {
        if (this.conf == null && this.serializedConf != null) {
            this.deSerializeConf();
        }
        return this.conf;
    }

    private void deSerializeConf() {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(this.serializedConf);
             ObjectInputStream ois = new ObjectInputStream(bis);){
            this.conf = new HiveConf();
            this.conf.readFields((DataInput)ois);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not deserialize conf", e);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.serializedConf == null && this.conf != null) {
            this.serializeConf();
        }
        out.defaultWriteObject();
    }

    private void serializeConf() throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             ObjectOutputStream oos = new ObjectOutputStream(bos);){
            this.conf.write((DataOutput)oos);
            oos.flush();
            this.serializedConf = bos.toByteArray();
        }
        catch (IOException e) {
            throw new IOException("Could not serialize conf", e);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }
}

