/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.job;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.dto.AuditDTO;
import org.apache.gravitino.dto.job.ShellJobTemplateDTO;
import org.apache.gravitino.dto.job.SparkJobTemplateDTO;
import org.apache.gravitino.job.JobTemplate;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="jobType", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=SparkJobTemplateDTO.class, name="spark"), @JsonSubTypes.Type(value=ShellJobTemplateDTO.class, name="shell")})
public abstract class JobTemplateDTO {
    @JsonDeserialize(using=JobTypeDeserializer.class)
    @JsonSerialize(using=JobTypeSerializer.class)
    @JsonProperty(value="jobType")
    private JobTemplate.JobType jobType;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="comment")
    private String comment;
    @JsonProperty(value="executable")
    private String executable;
    @JsonProperty(value="arguments")
    private List<String> arguments;
    @JsonProperty(value="environments")
    private Map<String, String> environments;
    @JsonProperty(value="customFields")
    private Map<String, String> customFields;
    @JsonProperty(value="audit")
    private AuditDTO audit;

    protected JobTemplateDTO() {
    }

    public void validate() {
        Preconditions.checkArgument((this.jobType != null ? 1 : 0) != 0, (Object)"\"jobType\" is required and cannot be null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.name), (Object)"\"name\" is required and cannot be empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.executable), (Object)"\"executable\" is required and cannot be empty");
    }

    protected JobTemplateDTO(JobTemplateDTOBuilder<?, ?> b) {
        this.jobType = b.jobType;
        this.name = b.name;
        this.comment = b.comment;
        this.executable = b.executable;
        this.arguments = b.arguments;
        this.environments = b.environments;
        this.customFields = b.customFields;
        this.audit = b.audit;
    }

    public JobTemplate.JobType jobType() {
        return this.jobType;
    }

    public String name() {
        return this.name;
    }

    public String comment() {
        return this.comment;
    }

    public String executable() {
        return this.executable;
    }

    public List<String> arguments() {
        return this.arguments;
    }

    public Map<String, String> environments() {
        return this.environments;
    }

    public Map<String, String> customFields() {
        return this.customFields;
    }

    public AuditDTO audit() {
        return this.audit;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JobTemplateDTO)) {
            return false;
        }
        JobTemplateDTO other = (JobTemplateDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JobTemplate.JobType this$jobType = this.jobType();
        JobTemplate.JobType other$jobType = other.jobType();
        if (this$jobType == null ? other$jobType != null : !this$jobType.equals(other$jobType)) {
            return false;
        }
        String this$name = this.name();
        String other$name = other.name();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$comment = this.comment();
        String other$comment = other.comment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        String this$executable = this.executable();
        String other$executable = other.executable();
        if (this$executable == null ? other$executable != null : !this$executable.equals(other$executable)) {
            return false;
        }
        List<String> this$arguments = this.arguments();
        List<String> other$arguments = other.arguments();
        if (this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments)) {
            return false;
        }
        Map<String, String> this$environments = this.environments();
        Map<String, String> other$environments = other.environments();
        if (this$environments == null ? other$environments != null : !((Object)this$environments).equals(other$environments)) {
            return false;
        }
        Map<String, String> this$customFields = this.customFields();
        Map<String, String> other$customFields = other.customFields();
        if (this$customFields == null ? other$customFields != null : !((Object)this$customFields).equals(other$customFields)) {
            return false;
        }
        AuditDTO this$audit = this.audit();
        AuditDTO other$audit = other.audit();
        return !(this$audit == null ? other$audit != null : !((Object)this$audit).equals(other$audit));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JobTemplateDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JobTemplate.JobType $jobType = this.jobType();
        result = result * 59 + ($jobType == null ? 43 : $jobType.hashCode());
        String $name = this.name();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $comment = this.comment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        String $executable = this.executable();
        result = result * 59 + ($executable == null ? 43 : $executable.hashCode());
        List<String> $arguments = this.arguments();
        result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
        Map<String, String> $environments = this.environments();
        result = result * 59 + ($environments == null ? 43 : ((Object)$environments).hashCode());
        Map<String, String> $customFields = this.customFields();
        result = result * 59 + ($customFields == null ? 43 : ((Object)$customFields).hashCode());
        AuditDTO $audit = this.audit();
        result = result * 59 + ($audit == null ? 43 : ((Object)$audit).hashCode());
        return result;
    }

    public String toString() {
        return "JobTemplateDTO(jobType=" + String.valueOf(this.jobType()) + ", name=" + this.name() + ", comment=" + this.comment() + ", executable=" + this.executable() + ", arguments=" + String.valueOf(this.arguments()) + ", environments=" + String.valueOf(this.environments()) + ", customFields=" + String.valueOf(this.customFields()) + ", audit=" + String.valueOf(this.audit()) + ")";
    }

    public static abstract class JobTemplateDTOBuilder<C extends JobTemplateDTO, B extends JobTemplateDTOBuilder<C, B>> {
        private JobTemplate.JobType jobType;
        private String name;
        private String comment;
        private String executable;
        private List<String> arguments;
        private Map<String, String> environments;
        private Map<String, String> customFields;
        private AuditDTO audit;

        protected abstract B self();

        public abstract C build();

        @JsonDeserialize(using=JobTypeDeserializer.class)
        @JsonProperty(value="jobType")
        public B withJobType(JobTemplate.JobType jobType) {
            this.jobType = jobType;
            return this.self();
        }

        @JsonProperty(value="name")
        public B withName(String name) {
            this.name = name;
            return this.self();
        }

        @JsonProperty(value="comment")
        public B withComment(String comment) {
            this.comment = comment;
            return this.self();
        }

        @JsonProperty(value="executable")
        public B withExecutable(String executable) {
            this.executable = executable;
            return this.self();
        }

        @JsonProperty(value="arguments")
        public B withArguments(List<String> arguments) {
            this.arguments = arguments;
            return this.self();
        }

        @JsonProperty(value="environments")
        public B withEnvironments(Map<String, String> environments) {
            this.environments = environments;
            return this.self();
        }

        @JsonProperty(value="customFields")
        public B withCustomFields(Map<String, String> customFields) {
            this.customFields = customFields;
            return this.self();
        }

        @JsonProperty(value="audit")
        public B withAudit(AuditDTO audit) {
            this.audit = audit;
            return this.self();
        }

        public String toString() {
            return "JobTemplateDTO.JobTemplateDTOBuilder(jobType=" + String.valueOf(this.jobType) + ", name=" + this.name + ", comment=" + this.comment + ", executable=" + this.executable + ", arguments=" + String.valueOf(this.arguments) + ", environments=" + String.valueOf(this.environments) + ", customFields=" + String.valueOf(this.customFields) + ", audit=" + String.valueOf(this.audit) + ")";
        }
    }

    public static class JobTypeSerializer
    extends JsonSerializer<JobTemplate.JobType> {
        public void serialize(JobTemplate.JobType value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"\"jobType\" cannot be null");
            gen.writeString(value.name().toLowerCase());
        }
    }

    public static class JobTypeDeserializer
    extends JsonDeserializer<JobTemplate.JobType> {
        public JobTemplate.JobType deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String value = p.getText();
            if (value != null) {
                try {
                    return JobTemplate.JobType.valueOf((String)value.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    throw ctxt.weirdStringException(value, JobTemplate.JobType.class, "Invalid jobType value");
                }
            }
            throw ctxt.weirdStringException(null, JobTemplate.JobType.class, "jobType cannot be null or empty");
        }
    }
}

