/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.casting;

import org.apache.paimon.casting.AbstractCastRule;
import org.apache.paimon.casting.CastExecutor;
import org.apache.paimon.casting.CastRulePredicate;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeFamily;

class NumericPrimitiveCastRule
extends AbstractCastRule<Number, Number> {
    static final NumericPrimitiveCastRule INSTANCE = new NumericPrimitiveCastRule();

    private NumericPrimitiveCastRule() {
        super(CastRulePredicate.builder().input(DataTypeFamily.INTEGER_NUMERIC).input(DataTypeFamily.APPROXIMATE_NUMERIC).target(DataTypeFamily.INTEGER_NUMERIC).target(DataTypeFamily.APPROXIMATE_NUMERIC).build());
    }

    @Override
    public CastExecutor<Number, Number> create(DataType inputType, DataType targetType) {
        switch (targetType.getTypeRoot()) {
            case TINYINT: {
                return Number::byteValue;
            }
            case SMALLINT: {
                return Number::shortValue;
            }
            case INTEGER: {
                return Number::intValue;
            }
            case BIGINT: {
                return Number::longValue;
            }
            case FLOAT: {
                return Number::floatValue;
            }
            case DOUBLE: {
                return Number::doubleValue;
            }
        }
        return null;
    }
}

