/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.casting;

import org.apache.paimon.casting.AbstractCastRule;
import org.apache.paimon.casting.CastExecutor;
import org.apache.paimon.casting.CastExecutors;
import org.apache.paimon.casting.CastRulePredicate;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeFamily;
import org.apache.paimon.types.DataTypeRoot;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.VarCharType;
import org.apache.paimon.utils.InternalRowUtils;

public class RowToStringCastRule
extends AbstractCastRule<InternalRow, BinaryString> {
    static final RowToStringCastRule INSTANCE = new RowToStringCastRule();

    private RowToStringCastRule() {
        super(CastRulePredicate.builder().input(DataTypeRoot.ROW).target(DataTypeFamily.CHARACTER_STRING).build());
    }

    @Override
    public CastExecutor<InternalRow, BinaryString> create(DataType inputType, DataType targetType) {
        RowType rowType = (RowType)inputType;
        int fieldCount = rowType.getFieldCount();
        InternalRow.FieldGetter[] fieldGetters = new InternalRow.FieldGetter[fieldCount];
        CastExecutor[] castExecutors = new CastExecutor[fieldCount];
        for (int i = 0; i < rowType.getFieldCount(); ++i) {
            DataType fieldType = rowType.getTypeAt(i);
            fieldGetters[i] = InternalRowUtils.createNullCheckingFieldGetter(fieldType, i);
            castExecutors[i] = CastExecutors.resolve(fieldType, (DataType)VarCharType.STRING_TYPE);
        }
        return rowDate -> {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            for (int i = 0; i < fieldCount; ++i) {
                Object field = fieldGetters[i].getFieldOrNull((InternalRow)rowDate);
                if (field == null) {
                    sb.append("null");
                } else {
                    sb.append(castExecutors[i].cast(field).toString());
                }
                if (i == fieldCount - 1) continue;
                sb.append(", ");
            }
            sb.append("}");
            return BinaryString.fromString(sb.toString());
        };
    }
}

