/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.fs;

import java.io.IOException;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.FileStatus;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.PositionOutputStream;
import org.apache.paimon.fs.SeekableInputStream;
import org.apache.paimon.options.Options;

public abstract class PluginFileIO
implements FileIO {
    private static final long serialVersionUID = 1L;
    protected Options options;
    private volatile transient FileIO lazyFileIO;

    @Override
    public void configure(CatalogContext context) {
        this.options = context.options();
    }

    @Override
    public SeekableInputStream newInputStream(Path path) throws IOException {
        return this.wrap(() -> this.fileIO(path).newInputStream(path));
    }

    @Override
    public PositionOutputStream newOutputStream(Path path, boolean overwrite) throws IOException {
        return this.wrap(() -> this.fileIO(path).newOutputStream(path, overwrite));
    }

    @Override
    public FileStatus getFileStatus(Path path) throws IOException {
        return this.wrap(() -> this.fileIO(path).getFileStatus(path));
    }

    @Override
    public FileStatus[] listStatus(Path path) throws IOException {
        return this.wrap(() -> this.fileIO(path).listStatus(path));
    }

    @Override
    public boolean exists(Path path) throws IOException {
        return this.wrap(() -> this.fileIO(path).exists(path));
    }

    @Override
    public boolean delete(Path path, boolean recursive) throws IOException {
        return this.wrap(() -> this.fileIO(path).delete(path, recursive));
    }

    @Override
    public boolean mkdirs(Path path) throws IOException {
        return this.wrap(() -> this.fileIO(path).mkdirs(path));
    }

    @Override
    public boolean rename(Path src, Path dst) throws IOException {
        return this.wrap(() -> this.fileIO(src).rename(src, dst));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileIO fileIO(Path path) throws IOException {
        if (this.lazyFileIO == null) {
            PluginFileIO pluginFileIO = this;
            synchronized (pluginFileIO) {
                if (this.lazyFileIO == null) {
                    this.lazyFileIO = this.wrap(() -> this.createFileIO(path));
                }
            }
        }
        return this.lazyFileIO;
    }

    protected abstract FileIO createFileIO(Path var1);

    protected abstract ClassLoader pluginClassLoader();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T wrap(Func<T> func) throws IOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.pluginClassLoader());
            T t = func.apply();
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    @FunctionalInterface
    protected static interface Func<T> {
        public T apply() throws IOException;
    }
}

