/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.security;

import java.io.IOException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.paimon.options.Options;
import org.apache.paimon.security.SecurityConfiguration;
import org.apache.paimon.utils.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosLoginProvider {
    private static final Logger LOG = LoggerFactory.getLogger(KerberosLoginProvider.class);
    private final String principal;
    private final String keytab;
    private final boolean useTicketCache;

    public KerberosLoginProvider(Options options) {
        Preconditions.checkNotNull((Object)options, (String)"options must not be null");
        SecurityConfiguration securityConfiguration = new SecurityConfiguration(options);
        this.principal = securityConfiguration.getPrincipal();
        this.keytab = securityConfiguration.getKeytab();
        this.useTicketCache = securityConfiguration.useTicketCache();
    }

    public KerberosLoginProvider(SecurityConfiguration config) {
        Preconditions.checkNotNull((Object)config, (String)"SecurityConfiguration must not be null");
        this.principal = config.getPrincipal();
        this.keytab = config.getKeytab();
        this.useTicketCache = config.useTicketCache();
    }

    public boolean isLoginPossible() throws IOException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            LOG.debug("Security is NOT enabled");
            return false;
        }
        LOG.debug("Security is enabled");
        UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
        if (this.principal != null) {
            LOG.debug("Login from keytab is possible");
            return true;
        }
        if (!KerberosLoginProvider.isProxyUser(currentUser)) {
            if (this.useTicketCache && currentUser.hasKerberosCredentials()) {
                LOG.debug("Login from ticket cache is possible");
                return true;
            }
        } else {
            this.throwProxyUserNotSupported();
        }
        LOG.debug("Login is NOT possible");
        return false;
    }

    public void doLogin() throws IOException {
        if (this.principal != null) {
            LOG.info("Attempting to login to KDC using principal: {} keytab: {}", (Object)this.principal, (Object)this.keytab);
            UserGroupInformation.loginUserFromKeytab((String)this.principal, (String)this.keytab);
            LOG.info("Successfully logged into KDC");
        } else if (!KerberosLoginProvider.isProxyUser(UserGroupInformation.getCurrentUser())) {
            LOG.info("Attempting to load user's ticket cache");
            UserGroupInformation.loginUserFromSubject(null);
            LOG.info("Loaded user's ticket cache successfully");
        } else {
            this.throwProxyUserNotSupported();
        }
    }

    private void throwProxyUserNotSupported() {
        throw new UnsupportedOperationException("Proxy user is not supported");
    }

    public static boolean isProxyUser(UserGroupInformation ugi) {
        return ugi.getAuthenticationMethod() == UserGroupInformation.AuthenticationMethod.PROXY;
    }

    public static boolean hasUserKerberosAuthMethod(UserGroupInformation ugi) {
        return UserGroupInformation.isSecurityEnabled() && ugi.getAuthenticationMethod() == UserGroupInformation.AuthenticationMethod.KERBEROS;
    }
}

