/*
 * Decompiled with CFR 0.152.
 */
package ognl;

import java.math.BigDecimal;
import java.math.BigInteger;
import ognl.ASTChain;
import ognl.ASTConst;
import ognl.ASTMethod;
import ognl.ASTProperty;
import ognl.ASTSequence;
import ognl.ASTStaticField;
import ognl.ASTStaticMethod;
import ognl.ASTTest;
import ognl.ASTVarRef;
import ognl.ExpressionNode;
import ognl.Node;
import ognl.NodeType;
import ognl.NumericExpression;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.OgnlOps;
import ognl.OgnlParser;
import ognl.OgnlRuntime;
import ognl.enhance.ExpressionCompiler;

public class ASTAdd
extends NumericExpression {
    private static final long serialVersionUID = -7027437312703768232L;

    public ASTAdd(int id) {
        super(id);
    }

    public ASTAdd(OgnlParser p, int id) {
        super(p, id);
    }

    @Override
    public void jjtClose() {
        this.flattenTree();
    }

    @Override
    protected Object getValueBody(OgnlContext context, Object source) throws OgnlException {
        Object result = this.children[0].getValue(context, source);
        for (int i = 1; i < this.children.length; ++i) {
            result = OgnlOps.add(result, this.children[i].getValue(context, source));
        }
        return result;
    }

    @Override
    public String getExpressionOperator(int index) {
        return "+";
    }

    boolean isWider(NodeType type, NodeType lastType) {
        if (lastType == null) {
            return true;
        }
        if (String.class.isAssignableFrom(lastType.getGetterClass())) {
            return false;
        }
        if (String.class.isAssignableFrom(type.getGetterClass())) {
            return true;
        }
        if (this.parent != null && String.class.isAssignableFrom(type.getGetterClass())) {
            return true;
        }
        if (String.class.isAssignableFrom(lastType.getGetterClass()) && Object.class == type.getGetterClass()) {
            return false;
        }
        if (this.parent != null && String.class.isAssignableFrom(lastType.getGetterClass())) {
            return false;
        }
        if (this.parent == null && String.class.isAssignableFrom(lastType.getGetterClass())) {
            return true;
        }
        if (this.parent == null && String.class.isAssignableFrom(type.getGetterClass())) {
            return false;
        }
        if (BigDecimal.class.isAssignableFrom(type.getGetterClass()) || BigInteger.class.isAssignableFrom(type.getGetterClass())) {
            return true;
        }
        if (BigDecimal.class.isAssignableFrom(lastType.getGetterClass()) || BigInteger.class.isAssignableFrom(lastType.getGetterClass())) {
            return false;
        }
        if (Double.class.isAssignableFrom(type.getGetterClass())) {
            return true;
        }
        if (Integer.class.isAssignableFrom(type.getGetterClass()) && Double.class.isAssignableFrom(lastType.getGetterClass())) {
            return false;
        }
        if (Float.class.isAssignableFrom(type.getGetterClass()) && Integer.class.isAssignableFrom(lastType.getGetterClass())) {
            return true;
        }
        return true;
    }

    @Override
    public String toGetSourceString(OgnlContext context, Object target) {
        try {
            StringBuilder result = new StringBuilder();
            NodeType lastType = null;
            if (this.children != null && this.children.length > 0) {
                Class<?> currType = context.getCurrentType();
                Class<?> currAccessor = context.getCurrentAccessor();
                Object cast = context.get("_preCast");
                for (Node child : this.children) {
                    child.toGetSourceString(context, target);
                    if (!(child instanceof NodeType) || ((NodeType)((Object)child)).getGetterClass() == null || !this.isWider((NodeType)((Object)child), lastType)) continue;
                    lastType = (NodeType)((Object)child);
                }
                context.put("_preCast", cast);
                context.setCurrentType(currType);
                context.setCurrentAccessor(currAccessor);
            }
            context.setCurrentObject(target);
            if (this.children != null && this.children.length > 0) {
                for (int i = 0; i < this.children.length; ++i) {
                    String expr;
                    if (i > 0) {
                        result.append(" ").append(this.getExpressionOperator(i)).append(" ");
                    }
                    if ("null".equals(expr = this.children[i].toGetSourceString(context, target)) || !(this.children[i] instanceof ASTConst) && (expr == null || expr.trim().length() <= 0)) {
                        expr = "null";
                    }
                    if (this.children[i] instanceof ASTProperty) {
                        expr = ExpressionCompiler.getRootExpression(this.children[i], context.getRoot(), context) + expr;
                        context.setCurrentAccessor(context.getRoot().getClass());
                    } else if (this.children[i] instanceof ASTMethod) {
                        String chain = (String)context.get("_currentChain");
                        String rootExpr = ExpressionCompiler.getRootExpression(this.children[i], context.getRoot(), context);
                        if (rootExpr.endsWith(".") && chain != null && chain.startsWith(").")) {
                            chain = chain.substring(1);
                        }
                        expr = rootExpr + (chain != null ? chain + "." : "") + expr;
                        context.setCurrentAccessor(context.getRoot().getClass());
                    } else if (this.children[i] instanceof ExpressionNode) {
                        expr = "(" + expr + ")";
                    } else if (!(this.parent instanceof ASTChain) && this.children[i] instanceof ASTChain) {
                        String rootExpr = ExpressionCompiler.getRootExpression(this.children[i], context.getRoot(), context);
                        if (!(this.children[i].jjtGetChild(0) instanceof ASTProperty) && rootExpr.endsWith(")") && expr.startsWith(")")) {
                            expr = expr.substring(1);
                        }
                        expr = rootExpr + expr;
                        context.setCurrentAccessor(context.getRoot().getClass());
                        String cast = (String)context.remove("_preCast");
                        if (cast == null) {
                            cast = "";
                        }
                        expr = cast + expr;
                    }
                    if (context.getCurrentType() != null && context.getCurrentType() == Character.class && this.children[i] instanceof ASTConst) {
                        if (expr.indexOf(39) >= 0) {
                            expr = expr.replaceAll("'", "\"");
                        }
                        context.setCurrentType(String.class);
                    } else if (!(ASTVarRef.class.isAssignableFrom(this.children[i].getClass()) || this.children[i] instanceof ASTProperty || this.children[i] instanceof ASTMethod || this.children[i] instanceof ASTSequence || this.children[i] instanceof ASTChain || NumericExpression.class.isAssignableFrom(this.children[i].getClass()) || this.children[i] instanceof ASTStaticField || this.children[i] instanceof ASTStaticMethod || this.children[i] instanceof ASTTest || lastType == null || !String.class.isAssignableFrom(lastType.getGetterClass()))) {
                        if (expr.contains("&quot;")) {
                            expr = expr.replaceAll("&quot;", "\"");
                        }
                        if (expr.indexOf(34) >= 0) {
                            expr = expr.replaceAll("\"", "'");
                        }
                        expr = "\"" + expr + "\"";
                    }
                    result.append(expr);
                    if (!(lastType != null && String.class.isAssignableFrom(lastType.getGetterClass()) || ASTConst.class.isAssignableFrom(this.children[i].getClass()) || NumericExpression.class.isAssignableFrom(this.children[i].getClass()) || context.getCurrentType() == null || !Number.class.isAssignableFrom(context.getCurrentType()) || this.children[i] instanceof ASTMethod)) {
                        if (this.children[i] instanceof ASTVarRef || this.children[i] instanceof ASTProperty || this.children[i] instanceof ASTChain) {
                            result.append(".");
                        }
                        result.append(OgnlRuntime.getNumericValueGetter(context.getCurrentType()));
                        context.setCurrentType(OgnlRuntime.getPrimitiveWrapperClass(context.getCurrentType()));
                    }
                    if (lastType == null) continue;
                    context.setCurrentAccessor(lastType.getGetterClass());
                }
            }
            if (this.parent == null || ASTSequence.class.isAssignableFrom(this.parent.getClass())) {
                if (this.getterClass != null && String.class.isAssignableFrom(this.getterClass)) {
                    this.getterClass = Object.class;
                }
            } else {
                context.setCurrentType(this.getterClass);
            }
            try {
                Object contextObj = this.getValueBody(context, target);
                context.setCurrentObject(contextObj);
            }
            catch (Throwable t) {
                throw OgnlOps.castToRuntime(t);
            }
            return result.toString();
        }
        catch (Throwable t) {
            throw OgnlOps.castToRuntime(t);
        }
    }
}

